package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class InstanceHealthSummary(
    noData: Option[NullableInteger] = None,
    unknown: Option[NullableInteger] = None,
    pending: Option[NullableInteger] = None,
    ok: Option[NullableInteger] = None,
    info: Option[NullableInteger] = None,
    warning: Option[NullableInteger] = None,
    degraded: Option[NullableInteger] = None,
    severe: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary = {
    import InstanceHealthSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
      .builder()
      .optionallyWith(noData.map(value => value: Integer))(_.noData)
      .optionallyWith(unknown.map(value => value: Integer))(_.unknown)
      .optionallyWith(pending.map(value => value: Integer))(_.pending)
      .optionallyWith(ok.map(value => value: Integer))(_.ok)
      .optionallyWith(info.map(value => value: Integer))(_.info)
      .optionallyWith(warning.map(value => value: Integer))(_.warning)
      .optionallyWith(degraded.map(value => value: Integer))(_.degraded)
      .optionallyWith(severe.map(value => value: Integer))(_.severe)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly =
    zio.aws.elasticbeanstalk.model.InstanceHealthSummary.wrap(buildAwsValue())
}
object InstanceHealthSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.InstanceHealthSummary =
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary(
        noData.map(value => value),
        unknown.map(value => value),
        pending.map(value => value),
        ok.map(value => value),
        info.map(value => value),
        warning.map(value => value),
        degraded.map(value => value),
        severe.map(value => value)
      )
    def noData: Option[NullableInteger]
    def unknown: Option[NullableInteger]
    def pending: Option[NullableInteger]
    def ok: Option[NullableInteger]
    def info: Option[NullableInteger]
    def warning: Option[NullableInteger]
    def degraded: Option[NullableInteger]
    def severe: Option[NullableInteger]
    def getNoData: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("noData", noData)
    def getUnknown: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("unknown", unknown)
    def getPending: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("pending", pending)
    def getOk: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("ok", ok)
    def getInfo: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("info", info)
    def getWarning: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("warning", warning)
    def getDegraded: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("degraded", degraded)
    def getSevere: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("severe", severe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ) extends zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly {
    override val noData: Option[NullableInteger] =
      scala.Option(impl.noData()).map(value => value: NullableInteger)
    override val unknown: Option[NullableInteger] =
      scala.Option(impl.unknown()).map(value => value: NullableInteger)
    override val pending: Option[NullableInteger] =
      scala.Option(impl.pending()).map(value => value: NullableInteger)
    override val ok: Option[NullableInteger] =
      scala.Option(impl.ok()).map(value => value: NullableInteger)
    override val info: Option[NullableInteger] =
      scala.Option(impl.info()).map(value => value: NullableInteger)
    override val warning: Option[NullableInteger] =
      scala.Option(impl.warning()).map(value => value: NullableInteger)
    override val degraded: Option[NullableInteger] =
      scala.Option(impl.degraded()).map(value => value: NullableInteger)
    override val severe: Option[NullableInteger] =
      scala.Option(impl.severe()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ): zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly =
    new Wrapper(impl)
}
