package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.ApplicationName
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResourceLifecycleResponse(
    applicationName: Option[ApplicationName] = None,
    resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse = {
    import UpdateApplicationResourceLifecycleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        resourceLifecycleConfig.map(value => value.buildAwsValue())
      )(_.resourceLifecycleConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResourceLifecycleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse =
      zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse(
        applicationName.map(value => value),
        resourceLifecycleConfig.map(value => value.asEditable)
      )
    def applicationName: Option[ApplicationName]
    def resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getResourceLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceLifecycleConfig",
      resourceLifecycleConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
  ) extends zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = scala
      .Option(impl.resourceLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
  ): zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly =
    new Wrapper(impl)
}
