package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{BoxedInt, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class BuildConfiguration(
    artifactName: Option[String] = None,
    codeBuildServiceRole: NonEmptyString,
    computeType: Option[zio.aws.elasticbeanstalk.model.ComputeType] = None,
    image: NonEmptyString,
    timeoutInMinutes: Option[BoxedInt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration = {
    import BuildConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration
      .builder()
      .optionallyWith(artifactName.map(value => value: java.lang.String))(
        _.artifactName
      )
      .codeBuildServiceRole(
        NonEmptyString.unwrap(codeBuildServiceRole): java.lang.String
      )
      .optionallyWith(computeType.map(value => value.unwrap))(_.computeType)
      .image(NonEmptyString.unwrap(image): java.lang.String)
      .optionallyWith(timeoutInMinutes.map(value => value: Integer))(
        _.timeoutInMinutes
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly =
    zio.aws.elasticbeanstalk.model.BuildConfiguration.wrap(buildAwsValue())
}
object BuildConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.BuildConfiguration =
      zio.aws.elasticbeanstalk.model.BuildConfiguration(
        artifactName.map(value => value),
        codeBuildServiceRole,
        computeType.map(value => value),
        image,
        timeoutInMinutes.map(value => value)
      )
    def artifactName: Option[String]
    def codeBuildServiceRole: NonEmptyString
    def computeType: Option[zio.aws.elasticbeanstalk.model.ComputeType]
    def image: NonEmptyString
    def timeoutInMinutes: Option[BoxedInt]
    def getArtifactName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getCodeBuildServiceRole: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(codeBuildServiceRole)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ComputeType] =
      AwsError.unwrapOptionField("computeType", computeType)
    def getImage: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(image)
    def getTimeoutInMinutes: ZIO[Any, AwsError, BoxedInt] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration
  ) extends zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly {
    override val artifactName: Option[String] =
      scala.Option(impl.artifactName()).map(value => value: String)
    override val codeBuildServiceRole: NonEmptyString =
      zio.aws.elasticbeanstalk.model.primitives
        .NonEmptyString(impl.codeBuildServiceRole())
    override val computeType
        : Option[zio.aws.elasticbeanstalk.model.ComputeType] = scala
      .Option(impl.computeType())
      .map(value => zio.aws.elasticbeanstalk.model.ComputeType.wrap(value))
    override val image: NonEmptyString =
      zio.aws.elasticbeanstalk.model.primitives.NonEmptyString(impl.image())
    override val timeoutInMinutes: Option[BoxedInt] =
      scala.Option(impl.timeoutInMinutes()).map(value => value: BoxedInt)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration
  ): zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
