package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnvironmentTier(
    name: Option[String] = None,
    `type`: Option[String] = None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier = {
    import EnvironmentTier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentTier.wrap(buildAwsValue())
}
object EnvironmentTier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EnvironmentTier =
      zio.aws.elasticbeanstalk.model.EnvironmentTier(
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value)
      )
    def name: Option[String]
    def `type`: Option[String]
    def version: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier
  ): zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly = new Wrapper(impl)
}
