package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationResourceLifecycleConfig(
    serviceRole: Option[String] = None,
    versionLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig = {
    import ApplicationResourceLifecycleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
      .builder()
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(
        versionLifecycleConfig.map(value => value.buildAwsValue())
      )(_.versionLifecycleConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
      .wrap(buildAwsValue())
}
object ApplicationResourceLifecycleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig =
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig(
        serviceRole.map(value => value),
        versionLifecycleConfig.map(value => value.asEditable)
      )
    def serviceRole: Option[String]
    def versionLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ]
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getVersionLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "versionLifecycleConfig",
      versionLifecycleConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ) extends zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly {
    override val serviceRole: Option[String] =
      scala.Option(impl.serviceRole()).map(value => value: String)
    override val versionLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly
    ] = scala
      .Option(impl.versionLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
  ): zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly =
    new Wrapper(impl)
}
