package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformName,
  BranchOrder,
  SupportedTier,
  PlatformBranchLifecycleState,
  BranchName
}
import scala.jdk.CollectionConverters._
final case class PlatformBranchSummary(
    platformName: Option[PlatformName] = None,
    branchName: Option[BranchName] = None,
    lifecycleState: Option[PlatformBranchLifecycleState] = None,
    branchOrder: Option[BranchOrder] = None,
    supportedTierList: Option[Iterable[SupportedTier]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary = {
    import PlatformBranchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
      .builder()
      .optionallyWith(
        platformName.map(value => PlatformName.unwrap(value): java.lang.String)
      )(_.platformName)
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .optionallyWith(
        lifecycleState.map(value =>
          PlatformBranchLifecycleState.unwrap(value): java.lang.String
        )
      )(_.lifecycleState)
      .optionallyWith(
        branchOrder.map(value => BranchOrder.unwrap(value): Integer)
      )(_.branchOrder)
      .optionallyWith(
        supportedTierList.map(value =>
          value.map { item =>
            SupportedTier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedTierList)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformBranchSummary.wrap(buildAwsValue())
}
object PlatformBranchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformBranchSummary =
      zio.aws.elasticbeanstalk.model.PlatformBranchSummary(
        platformName.map(value => value),
        branchName.map(value => value),
        lifecycleState.map(value => value),
        branchOrder.map(value => value),
        supportedTierList.map(value => value)
      )
    def platformName: Option[PlatformName]
    def branchName: Option[BranchName]
    def lifecycleState: Option[PlatformBranchLifecycleState]
    def branchOrder: Option[BranchOrder]
    def supportedTierList: Option[List[SupportedTier]]
    def getPlatformName: ZIO[Any, AwsError, PlatformName] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getLifecycleState: ZIO[Any, AwsError, PlatformBranchLifecycleState] =
      AwsError.unwrapOptionField("lifecycleState", lifecycleState)
    def getBranchOrder: ZIO[Any, AwsError, BranchOrder] =
      AwsError.unwrapOptionField("branchOrder", branchOrder)
    def getSupportedTierList: ZIO[Any, AwsError, List[SupportedTier]] =
      AwsError.unwrapOptionField("supportedTierList", supportedTierList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ) extends zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly {
    override val platformName: Option[PlatformName] = scala
      .Option(impl.platformName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformName(value)
      )
    override val branchName: Option[BranchName] = scala
      .Option(impl.branchName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.BranchName(value))
    override val lifecycleState: Option[PlatformBranchLifecycleState] = scala
      .Option(impl.lifecycleState())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .PlatformBranchLifecycleState(value)
      )
    override val branchOrder: Option[BranchOrder] = scala
      .Option(impl.branchOrder())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.BranchOrder(value)
      )
    override val supportedTierList: Option[List[SupportedTier]] = scala
      .Option(impl.supportedTierList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.SupportedTier(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary
  ): zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly =
    new Wrapper(impl)
}
