package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  VersionLabel,
  PlatformArn,
  EnvironmentId,
  Description,
  GroupName
}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentRequest(
    applicationName: Option[ApplicationName] = None,
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None,
    groupName: Option[GroupName] = None,
    description: Option[Description] = None,
    tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier] = None,
    versionLabel: Option[VersionLabel] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    optionSettings: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = None,
    optionsToRemove: Option[
      Iterable[zio.aws.elasticbeanstalk.model.OptionSpecification]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        optionsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionsToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest
      .wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest =
      zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest(
        applicationName.map(value => value),
        environmentId.map(value => value),
        environmentName.map(value => value),
        groupName.map(value => value),
        description.map(value => value),
        tier.map(value => value.asEditable),
        versionLabel.map(value => value),
        templateName.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: Option[ApplicationName]
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def groupName: Option[GroupName]
    def description: Option[Description]
    def tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly]
    def versionLabel: Option[VersionLabel]
    def templateName: Option[ConfigurationTemplateName]
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def optionsToRemove: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getOptionsToRemove: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("optionsToRemove", optionsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest
  ) extends zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.GroupName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val tier
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly] =
      scala
        .Option(impl.tier())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentTier.wrap(value)
        )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val optionSettings: Option[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val optionsToRemove: Option[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ] = scala
      .Option(impl.optionsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest
  ): zio.aws.elasticbeanstalk.model.UpdateEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
