package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus
}
object EnvironmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus
  ): zio.aws.elasticbeanstalk.model.EnvironmentStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.ABORTING =>
      val r = Aborting
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LAUNCHING =>
      val r = Launching
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LINKING_FROM =>
      val r = LinkingFrom
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LINKING_TO =>
      val r = LinkingTo
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.READY =>
      val r = Ready
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.TERMINATING =>
      val r = Terminating
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.TERMINATED =>
      val r = Terminated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Aborting
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.ABORTING
  }
  case object Launching
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LAUNCHING
  }
  case object Updating
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.UPDATING
  }
  case object LinkingFrom
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LINKING_FROM
  }
  case object LinkingTo
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.LINKING_TO
  }
  case object Ready extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.READY
  }
  case object Terminating
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.TERMINATING
  }
  case object Terminated
      extends zio.aws.elasticbeanstalk.model.EnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus.TERMINATED
  }
}
