package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  SearchFilterValue,
  SearchFilterOperator,
  SearchFilterAttribute
}
import scala.jdk.CollectionConverters._
final case class SearchFilter(
    attribute: Option[SearchFilterAttribute] = None,
    operator: Option[SearchFilterOperator] = None,
    values: Option[Iterable[SearchFilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter = {
    import SearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
      .builder()
      .optionallyWith(
        attribute.map(value =>
          SearchFilterAttribute.unwrap(value): java.lang.String
        )
      )(_.attribute)
      .optionallyWith(
        operator.map(value =>
          SearchFilterOperator.unwrap(value): java.lang.String
        )
      )(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            SearchFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly =
    zio.aws.elasticbeanstalk.model.SearchFilter.wrap(buildAwsValue())
}
object SearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SearchFilter =
      zio.aws.elasticbeanstalk.model.SearchFilter(
        attribute.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def attribute: Option[SearchFilterAttribute]
    def operator: Option[SearchFilterOperator]
    def values: Option[List[SearchFilterValue]]
    def getAttribute: ZIO[Any, AwsError, SearchFilterAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperator: ZIO[Any, AwsError, SearchFilterOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[SearchFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ) extends zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly {
    override val attribute: Option[SearchFilterAttribute] = scala
      .Option(impl.attribute())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SearchFilterAttribute(value)
      )
    override val operator: Option[SearchFilterOperator] = scala
      .Option(impl.operator())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SearchFilterOperator(value)
      )
    override val values: Option[List[SearchFilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.SearchFilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SearchFilter
  ): zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly = new Wrapper(impl)
}
