package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.NullableDouble
import scala.jdk.CollectionConverters._
final case class CPUUtilization(
    user: Option[NullableDouble] = None,
    nice: Option[NullableDouble] = None,
    system: Option[NullableDouble] = None,
    idle: Option[NullableDouble] = None,
    ioWait: Option[NullableDouble] = None,
    irq: Option[NullableDouble] = None,
    softIRQ: Option[NullableDouble] = None,
    privileged: Option[NullableDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization = {
    import CPUUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
      .builder()
      .optionallyWith(
        user.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.user)
      .optionallyWith(
        nice.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.nice)
      .optionallyWith(
        system.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.system)
      .optionallyWith(
        idle.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.idle)
      .optionallyWith(
        ioWait.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.ioWait)
      .optionallyWith(
        irq.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.irq)
      .optionallyWith(
        softIRQ.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.softIRQ)
      .optionallyWith(
        privileged.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.privileged)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly =
    zio.aws.elasticbeanstalk.model.CPUUtilization.wrap(buildAwsValue())
}
object CPUUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.CPUUtilization =
      zio.aws.elasticbeanstalk.model.CPUUtilization(
        user.map(value => value),
        nice.map(value => value),
        system.map(value => value),
        idle.map(value => value),
        ioWait.map(value => value),
        irq.map(value => value),
        softIRQ.map(value => value),
        privileged.map(value => value)
      )
    def user: Option[NullableDouble]
    def nice: Option[NullableDouble]
    def system: Option[NullableDouble]
    def idle: Option[NullableDouble]
    def ioWait: Option[NullableDouble]
    def irq: Option[NullableDouble]
    def softIRQ: Option[NullableDouble]
    def privileged: Option[NullableDouble]
    def getUser: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("user", user)
    def getNice: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("nice", nice)
    def getSystem: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("system", system)
    def getIdle: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("idle", idle)
    def getIoWait: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("ioWait", ioWait)
    def getIrq: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("irq", irq)
    def getSoftIRQ: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("softIRQ", softIRQ)
    def getPrivileged: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("privileged", privileged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ) extends zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly {
    override val user: Option[NullableDouble] = scala
      .Option(impl.user())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val nice: Option[NullableDouble] = scala
      .Option(impl.nice())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val system: Option[NullableDouble] = scala
      .Option(impl.system())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val idle: Option[NullableDouble] = scala
      .Option(impl.idle())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val ioWait: Option[NullableDouble] = scala
      .Option(impl.ioWait())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val irq: Option[NullableDouble] = scala
      .Option(impl.irq())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val softIRQ: Option[NullableDouble] = scala
      .Option(impl.softIRQ())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val privileged: Option[NullableDouble] = scala
      .Option(impl.privileged())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization
  ): zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly = new Wrapper(impl)
}
