package zio.aws.elasticbeanstalk
import zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.elasticbeanstalk.model.{
  UpdateApplicationRequest,
  CreatePlatformVersionRequest,
  DeleteConfigurationTemplateRequest,
  DeleteApplicationRequest,
  AssociateEnvironmentOperationsRoleRequest,
  DeleteApplicationVersionRequest,
  UpdateTagsForResourceRequest,
  DescribeEnvironmentHealthRequest,
  UpdateApplicationVersionRequest,
  RebuildEnvironmentRequest,
  ApplyEnvironmentManagedActionRequest,
  CheckDnsAvailabilityRequest,
  CreateApplicationVersionRequest,
  UpdateConfigurationTemplateRequest,
  UpdateApplicationResourceLifecycleRequest,
  DescribeEventsRequest,
  UpdateEnvironmentRequest,
  DescribeEnvironmentResourcesRequest,
  ListPlatformBranchesRequest,
  RequestEnvironmentInfoRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  RetrieveEnvironmentInfoRequest,
  SwapEnvironmentCnamEsRequest,
  DescribeEnvironmentsRequest,
  DeletePlatformVersionRequest,
  DescribeApplicationsRequest,
  DescribeInstancesHealthRequest,
  ComposeEnvironmentsRequest,
  DescribeConfigurationSettingsRequest,
  DescribeApplicationVersionsRequest,
  ListPlatformVersionsRequest,
  DisassociateEnvironmentOperationsRoleRequest,
  DescribePlatformVersionRequest,
  CreateConfigurationTemplateRequest,
  DescribeConfigurationOptionsRequest,
  DeleteEnvironmentConfigurationRequest,
  DescribeEnvironmentManagedActionHistoryRequest,
  TerminateEnvironmentRequest,
  RestartAppServerRequest,
  CreateEnvironmentRequest,
  ValidateConfigurationSettingsRequest,
  DescribeEnvironmentManagedActionsRequest,
  AbortEnvironmentUpdateRequest
}
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ElasticBeanstalkMock extends Mock[ElasticBeanstalk] {
  object DescribeConfigurationOptions
      extends Effect[
        DescribeConfigurationOptionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly
      ]
  object CreatePlatformVersion
      extends Effect[
        CreatePlatformVersionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[DeleteApplicationRequest, AwsError, Unit]
  object ListPlatformVersions
      extends Stream[
        ListPlatformVersionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
      ]
  object ListPlatformVersionsPaginated
      extends Effect[
        ListPlatformVersionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly
      ]
  object CheckDNSAvailability
      extends Effect[
        CheckDnsAvailabilityRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly
      ]
  object ValidateConfigurationSettings
      extends Effect[
        ValidateConfigurationSettingsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly
      ]
  object RetrieveEnvironmentInfo
      extends Effect[
        RetrieveEnvironmentInfoRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly
      ]
  object DescribePlatformVersion
      extends Effect[
        DescribePlatformVersionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly
      ]
  object UpdateTagsForResource
      extends Effect[UpdateTagsForResourceRequest, AwsError, Unit]
  object DeleteApplicationVersion
      extends Effect[DeleteApplicationVersionRequest, AwsError, Unit]
  object ListPlatformBranches
      extends Stream[
        ListPlatformBranchesRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
      ]
  object ListPlatformBranchesPaginated
      extends Effect[
        ListPlatformBranchesRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly
      ]
  object CreateApplicationVersion
      extends Effect[
        CreateApplicationVersionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.ReadOnly
      ]
  object DeleteConfigurationTemplate
      extends Effect[DeleteConfigurationTemplateRequest, AwsError, Unit]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreateApplicationResponse.ReadOnly
      ]
  object CreateConfigurationTemplate
      extends Effect[
        CreateConfigurationTemplateRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.ReadOnly
      ]
  object DescribeEnvironmentManagedActions
      extends Effect[
        DescribeEnvironmentManagedActionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly
      ]
  object DescribeEnvironmentResources
      extends Effect[
        DescribeEnvironmentResourcesRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly
      ]
  object CreateStorageLocation
      extends Effect[
        Unit,
        AwsError,
        zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly
      ]
  object DeleteEnvironmentConfiguration
      extends Effect[DeleteEnvironmentConfigurationRequest, AwsError, Unit]
  object AbortEnvironmentUpdate
      extends Effect[AbortEnvironmentUpdateRequest, AwsError, Unit]
  object SwapEnvironmentCNAMEs
      extends Effect[SwapEnvironmentCnamEsRequest, AwsError, Unit]
  object DescribeConfigurationSettings
      extends Effect[
        DescribeConfigurationSettingsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly
      ]
  object ListAvailableSolutionStacks
      extends Effect[
        Unit,
        AwsError,
        zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly
      ]
  object RestartAppServer
      extends Effect[RestartAppServerRequest, AwsError, Unit]
  object ComposeEnvironments
      extends Effect[
        ComposeEnvironmentsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly
      ]
  object DisassociateEnvironmentOperationsRole
      extends Effect[
        DisassociateEnvironmentOperationsRoleRequest,
        AwsError,
        Unit
      ]
  object DescribeApplicationVersions
      extends Stream[
        DescribeApplicationVersionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
      ]
  object DescribeApplicationVersionsPaginated
      extends Effect[
        DescribeApplicationVersionsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly
      ]
  object AssociateEnvironmentOperationsRole
      extends Effect[AssociateEnvironmentOperationsRoleRequest, AwsError, Unit]
  object UpdateApplicationResourceLifecycle
      extends Effect[
        UpdateApplicationResourceLifecycleRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly
      ]
  object RequestEnvironmentInfo
      extends Effect[RequestEnvironmentInfoRequest, AwsError, Unit]
  object RebuildEnvironment
      extends Effect[RebuildEnvironmentRequest, AwsError, Unit]
  object DescribeEnvironments
      extends Stream[
        DescribeEnvironmentsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
      ]
  object DescribeEnvironmentsPaginated
      extends Effect[
        DescribeEnvironmentsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly
      ]
  object ApplyEnvironmentManagedAction
      extends Effect[
        ApplyEnvironmentManagedActionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly
      ]
  object DescribeApplications
      extends Effect[
        DescribeApplicationsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object DescribeInstancesHealth
      extends Effect[DescribeInstancesHealthRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly,
        zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
      ]]
  object DescribeInstancesHealthPaginated
      extends Effect[
        DescribeInstancesHealthRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly
      ]
  object UpdateApplicationVersion
      extends Effect[
        UpdateApplicationVersionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.ReadOnly
      ]
  object TerminateEnvironment
      extends Effect[
        TerminateEnvironmentRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[UpdateApplicationRequest, AwsError, ReadOnly]
  object DeletePlatformVersion
      extends Effect[
        DeletePlatformVersionRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly
      ]
  object DescribeEnvironmentManagedActionHistory
      extends Stream[
        DescribeEnvironmentManagedActionHistoryRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
      ]
  object DescribeEnvironmentManagedActionHistoryPaginated
      extends Effect[
        DescribeEnvironmentManagedActionHistoryRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        Unit,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object UpdateConfigurationTemplate
      extends Effect[
        UpdateConfigurationTemplateRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly
      ]
  object DescribeEnvironmentHealth
      extends Effect[
        DescribeEnvironmentHealthRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElasticBeanstalk] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ElasticBeanstalk {
          val api: ElasticBeanstalkAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ElasticBeanstalk = this
          def describeConfigurationOptions(
              request: DescribeConfigurationOptionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsResponse.ReadOnly
          ] = proxy(DescribeConfigurationOptions, request)
          def createPlatformVersion(request: CreatePlatformVersionRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly
          ] = proxy(CreatePlatformVersion, request)
          def deleteApplication(
              request: DeleteApplicationRequest
          ): IO[AwsError, Unit] = proxy(DeleteApplication, request)
          def listPlatformVersions(
              request: ListPlatformVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListPlatformVersions, request))
          def listPlatformVersionsPaginated(
              request: ListPlatformVersionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly
          ] = proxy(ListPlatformVersionsPaginated, request)
          def checkDNSAvailability(request: CheckDnsAvailabilityRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CheckDnsAvailabilityResponse.ReadOnly
          ] = proxy(CheckDNSAvailability, request)
          def validateConfigurationSettings(
              request: ValidateConfigurationSettingsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ValidateConfigurationSettingsResponse.ReadOnly
          ] = proxy(ValidateConfigurationSettings, request)
          def retrieveEnvironmentInfo(
              request: RetrieveEnvironmentInfoRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse.ReadOnly
          ] = proxy(RetrieveEnvironmentInfo, request)
          def describePlatformVersion(
              request: DescribePlatformVersionRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribePlatformVersionResponse.ReadOnly
          ] = proxy(DescribePlatformVersion, request)
          def updateTagsForResource(
              request: UpdateTagsForResourceRequest
          ): IO[AwsError, Unit] = proxy(UpdateTagsForResource, request)
          def deleteApplicationVersion(
              request: DeleteApplicationVersionRequest
          ): IO[AwsError, Unit] = proxy(DeleteApplicationVersion, request)
          def listPlatformBranches(
              request: ListPlatformBranchesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListPlatformBranches, request))
          def listPlatformBranchesPaginated(
              request: ListPlatformBranchesRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly
          ] = proxy(ListPlatformBranchesPaginated, request)
          def createApplicationVersion(
              request: CreateApplicationVersionRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly
          ] = proxy(CreateApplicationVersion, request)
          def createEnvironment(request: CreateEnvironmentRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreateEnvironmentResponse.ReadOnly
          ] = proxy(CreateEnvironment, request)
          def deleteConfigurationTemplate(
              request: DeleteConfigurationTemplateRequest
          ): IO[AwsError, Unit] = proxy(DeleteConfigurationTemplate, request)
          def createApplication(request: CreateApplicationRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreateApplicationResponse.ReadOnly
          ] = proxy(CreateApplication, request)
          def createConfigurationTemplate(
              request: CreateConfigurationTemplateRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateResponse.ReadOnly
          ] = proxy(CreateConfigurationTemplate, request)
          def describeEnvironmentManagedActions(
              request: DescribeEnvironmentManagedActionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse.ReadOnly
          ] = proxy(DescribeEnvironmentManagedActions, request)
          def describeEnvironmentResources(
              request: DescribeEnvironmentResourcesRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse.ReadOnly
          ] = proxy(DescribeEnvironmentResources, request)
          def createStorageLocation(): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.CreateStorageLocationResponse.ReadOnly
          ] = proxy(CreateStorageLocation)
          def deleteEnvironmentConfiguration(
              request: DeleteEnvironmentConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteEnvironmentConfiguration, request)
          def abortEnvironmentUpdate(
              request: AbortEnvironmentUpdateRequest
          ): IO[AwsError, Unit] = proxy(AbortEnvironmentUpdate, request)
          def swapEnvironmentCNAMEs(
              request: SwapEnvironmentCnamEsRequest
          ): IO[AwsError, Unit] = proxy(SwapEnvironmentCNAMEs, request)
          def describeConfigurationSettings(
              request: DescribeConfigurationSettingsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeConfigurationSettingsResponse.ReadOnly
          ] = proxy(DescribeConfigurationSettings, request)
          def listAvailableSolutionStacks(): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ListAvailableSolutionStacksResponse.ReadOnly
          ] = proxy(ListAvailableSolutionStacks)
          def restartAppServer(
              request: RestartAppServerRequest
          ): IO[AwsError, Unit] = proxy(RestartAppServer, request)
          def composeEnvironments(request: ComposeEnvironmentsRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly
          ] = proxy(ComposeEnvironments, request)
          def disassociateEnvironmentOperationsRole(
              request: DisassociateEnvironmentOperationsRoleRequest
          ): IO[AwsError, Unit] =
            proxy(DisassociateEnvironmentOperationsRole, request)
          def describeApplicationVersions(
              request: DescribeApplicationVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeApplicationVersions, request))
          def describeApplicationVersionsPaginated(
              request: DescribeApplicationVersionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly
          ] = proxy(DescribeApplicationVersionsPaginated, request)
          def associateEnvironmentOperationsRole(
              request: AssociateEnvironmentOperationsRoleRequest
          ): IO[AwsError, Unit] =
            proxy(AssociateEnvironmentOperationsRole, request)
          def updateApplicationResourceLifecycle(
              request: UpdateApplicationResourceLifecycleRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse.ReadOnly
          ] = proxy(UpdateApplicationResourceLifecycle, request)
          def requestEnvironmentInfo(
              request: RequestEnvironmentInfoRequest
          ): IO[AwsError, Unit] = proxy(RequestEnvironmentInfo, request)
          def rebuildEnvironment(
              request: RebuildEnvironmentRequest
          ): IO[AwsError, Unit] = proxy(RebuildEnvironment, request)
          def describeEnvironments(
              request: DescribeEnvironmentsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEnvironments, request))
          def describeEnvironmentsPaginated(
              request: DescribeEnvironmentsRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEnvironmentsResponse.ReadOnly
          ] = proxy(DescribeEnvironmentsPaginated, request)
          def applyEnvironmentManagedAction(
              request: ApplyEnvironmentManagedActionRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly
          ] = proxy(ApplyEnvironmentManagedAction, request)
          def describeApplications(request: DescribeApplicationsRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeApplicationsResponse.ReadOnly
          ] = proxy(DescribeApplications, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def updateEnvironment(request: UpdateEnvironmentRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.UpdateEnvironmentResponse.ReadOnly
          ] = proxy(UpdateEnvironment, request)
          def describeInstancesHealth(
              request: DescribeInstancesHealthRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly,
            zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
          ]] = proxy(DescribeInstancesHealth, request)
          def describeInstancesHealthPaginated(
              request: DescribeInstancesHealthRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly
          ] = proxy(DescribeInstancesHealthPaginated, request)
          def updateApplicationVersion(
              request: UpdateApplicationVersionRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.UpdateApplicationVersionResponse.ReadOnly
          ] = proxy(UpdateApplicationVersion, request)
          def terminateEnvironment(request: TerminateEnvironmentRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly
          ] = proxy(TerminateEnvironment, request)
          def updateApplication(
              request: UpdateApplicationRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateApplication, request)
          def deletePlatformVersion(request: DeletePlatformVersionRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DeletePlatformVersionResponse.ReadOnly
          ] = proxy(DeletePlatformVersion, request)
          def describeEnvironmentManagedActionHistory(
              request: DescribeEnvironmentManagedActionHistoryRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly
          ] = rts.unsafeRun(
            proxy(DescribeEnvironmentManagedActionHistory, request)
          )
          def describeEnvironmentManagedActionHistoryPaginated(
              request: DescribeEnvironmentManagedActionHistoryRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse.ReadOnly
          ] = proxy(DescribeEnvironmentManagedActionHistoryPaginated, request)
          def describeAccountAttributes(): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeAccountAttributesResponse.ReadOnly
          ] = proxy(DescribeAccountAttributes)
          def updateConfigurationTemplate(
              request: UpdateConfigurationTemplateRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly
          ] = proxy(UpdateConfigurationTemplate, request)
          def describeEnvironmentHealth(
              request: DescribeEnvironmentHealthRequest
          ): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly
          ] = proxy(DescribeEnvironmentHealth, request)
          def describeEvents(request: DescribeEventsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEvents, request))
          def describeEventsPaginated(request: DescribeEventsRequest): IO[
            AwsError,
            zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly
          ] = proxy(DescribeEventsPaginated, request)
        }
      }
    }
    .toLayer
}
