package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  DeploymentTimestamp,
  NullableLong
}
import scala.jdk.CollectionConverters._
final case class Deployment(
    versionLabel: Option[String] = None,
    deploymentId: Option[NullableLong] = None,
    status: Option[String] = None,
    deploymentTime: Option[DeploymentTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
      .builder()
      .optionallyWith(versionLabel.map(value => value: java.lang.String))(
        _.versionLabel
      )
      .optionallyWith(
        deploymentId.map(value => NullableLong.unwrap(value): java.lang.Long)
      )(_.deploymentId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        deploymentTime.map(value => DeploymentTimestamp.unwrap(value): Instant)
      )(_.deploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Deployment.ReadOnly =
    zio.aws.elasticbeanstalk.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Deployment =
      zio.aws.elasticbeanstalk.model.Deployment(
        versionLabel.map(value => value),
        deploymentId.map(value => value),
        status.map(value => value),
        deploymentTime.map(value => value)
      )
    def versionLabel: Option[String]
    def deploymentId: Option[NullableLong]
    def status: Option[String]
    def deploymentTime: Option[DeploymentTimestamp]
    def getVersionLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getDeploymentId: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDeploymentTime: ZIO[Any, AwsError, DeploymentTimestamp] =
      AwsError.unwrapOptionField("deploymentTime", deploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ) extends zio.aws.elasticbeanstalk.model.Deployment.ReadOnly {
    override val versionLabel: Option[String] =
      scala.Option(impl.versionLabel()).map(value => value: String)
    override val deploymentId: Option[NullableLong] = scala
      .Option(impl.deploymentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableLong(value)
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val deploymentTime: Option[DeploymentTimestamp] = scala
      .Option(impl.deploymentTime())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.DeploymentTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ): zio.aws.elasticbeanstalk.model.Deployment.ReadOnly = new Wrapper(impl)
}
