package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait InstancesHealthAttribute {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute
}
object InstancesHealthAttribute {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute
  ): zio.aws.elasticbeanstalk.model.InstancesHealthAttribute = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.HEALTH_STATUS =>
      val r = HealthStatus
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.COLOR =>
      val r = Color
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.CAUSES =>
      val r = Causes
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.APPLICATION_METRICS =>
      val r = ApplicationMetrics
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.REFRESHED_AT =>
      val r = RefreshedAt
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.LAUNCHED_AT =>
      val r = LaunchedAt
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.SYSTEM =>
      val r = System
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.DEPLOYMENT =>
      val r = Deployment
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.AVAILABILITY_ZONE =>
      val r = AvailabilityZone
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.INSTANCE_TYPE =>
      val r = InstanceType
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.ALL =>
      val r = All
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object HealthStatus
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.HEALTH_STATUS
  }
  case object Color
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.COLOR
  }
  case object Causes
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.CAUSES
  }
  case object ApplicationMetrics
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.APPLICATION_METRICS
  }
  case object RefreshedAt
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.REFRESHED_AT
  }
  case object LaunchedAt
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.LAUNCHED_AT
  }
  case object System
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.SYSTEM
  }
  case object Deployment
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.DEPLOYMENT
  }
  case object AvailabilityZone
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.AVAILABILITY_ZONE
  }
  case object InstanceType
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.INSTANCE_TYPE
  }
  case object All
      extends zio.aws.elasticbeanstalk.model.InstancesHealthAttribute {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute =
      software.amazon.awssdk.services.elasticbeanstalk.model.InstancesHealthAttribute.ALL
  }
}
