package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateApplicationVersionResponse(
    applicationVersion: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse = {
    import CreateApplicationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse
      .builder()
      .optionallyWith(applicationVersion.map(value => value.buildAwsValue()))(
        _.applicationVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse
      .wrap(buildAwsValue())
}
object CreateApplicationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse =
      zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse(
        applicationVersion.map(value => value.asEditable)
      )
    def applicationVersion: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ]
    def getApplicationVersion: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ] = AwsError.unwrapOptionField("applicationVersion", applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse
  ) extends zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly {
    override val applicationVersion: Option[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ] = scala
      .Option(impl.applicationVersion())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse
  ): zio.aws.elasticbeanstalk.model.CreateApplicationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
