package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class AutoScalingGroup(name: Option[ResourceId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup = {
    import AutoScalingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup
      .builder()
      .optionallyWith(
        name.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly =
    zio.aws.elasticbeanstalk.model.AutoScalingGroup.wrap(buildAwsValue())
}
object AutoScalingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.AutoScalingGroup =
      zio.aws.elasticbeanstalk.model.AutoScalingGroup(name.map(value => value))
    def name: Option[ResourceId]
    def getName: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup
  ) extends zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly {
    override val name: Option[ResourceId] = scala
      .Option(impl.name())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup
  ): zio.aws.elasticbeanstalk.model.AutoScalingGroup.ReadOnly = new Wrapper(
    impl
  )
}
