package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.PlatformArn
import scala.jdk.CollectionConverters._
final case class DescribePlatformVersionRequest(
    platformArn: Option[PlatformArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest = {
    import DescribePlatformVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest
      .builder()
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribePlatformVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribePlatformVersionRequest
      .wrap(buildAwsValue())
}
object DescribePlatformVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribePlatformVersionRequest =
      zio.aws.elasticbeanstalk.model
        .DescribePlatformVersionRequest(platformArn.map(value => value))
    def platformArn: Option[PlatformArn]
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribePlatformVersionRequest.ReadOnly {
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest
  ): zio.aws.elasticbeanstalk.model.DescribePlatformVersionRequest.ReadOnly =
    new Wrapper(impl)
}
