package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class DescribeEventsResponse(
    events: Option[Iterable[zio.aws.elasticbeanstalk.model.EventDescription]] =
      None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DescribeEventsResponse =
      zio.aws.elasticbeanstalk.model.DescribeEventsResponse(
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def events
        : Option[List[zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly]]
    def nextToken: Option[Token]
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly {
    override val events: Option[
      List[zio.aws.elasticbeanstalk.model.EventDescription.ReadOnly]
    ] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EventDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEventsResponse.ReadOnly =
    new Wrapper(impl)
}
