package zio.aws.elasticbeanstalk
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  LoadAverageValue,
  FileTypeExtension,
  ConfigurationTemplateName,
  ConfigurationOptionPossibleValue,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  VersionLabel,
  SupportedTier,
  PlatformFilterValue,
  SearchFilterValue,
  EnvironmentId,
  SupportedAddon,
  Cause,
  TagKey
}
import zio.aws.elasticbeanstalk.model.primitives.ResourceArn.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.elasticbeanstalk.model.primitives.ARN.Type
    object AbortableOperationInProgress extends Subtype[Boolean]
    type AbortableOperationInProgress =
      zio.aws.elasticbeanstalk.model.primitives.AbortableOperationInProgress.Type
    object ApplicationArn extends Subtype[String]
    type ApplicationArn =
      zio.aws.elasticbeanstalk.model.primitives.ApplicationArn.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives.ApplicationName.Type
    object ApplicationVersionArn extends Subtype[String]
    type ApplicationVersionArn =
      zio.aws.elasticbeanstalk.model.primitives.ApplicationVersionArn.Type
    object ApplicationVersionProccess extends Subtype[Boolean]
    type ApplicationVersionProccess =
      zio.aws.elasticbeanstalk.model.primitives.ApplicationVersionProccess.Type
    object AutoCreateApplication extends Subtype[Boolean]
    type AutoCreateApplication =
      zio.aws.elasticbeanstalk.model.primitives.AutoCreateApplication.Type
    object BoxedBoolean extends Subtype[Boolean]
    type BoxedBoolean =
      zio.aws.elasticbeanstalk.model.primitives.BoxedBoolean.Type
    object BoxedInt extends Subtype[Int]
    type BoxedInt = zio.aws.elasticbeanstalk.model.primitives.BoxedInt.Type
    object BranchName extends Subtype[String]
    type BranchName = zio.aws.elasticbeanstalk.model.primitives.BranchName.Type
    object BranchOrder extends Subtype[Int]
    type BranchOrder =
      zio.aws.elasticbeanstalk.model.primitives.BranchOrder.Type
    object Cause extends Subtype[String]
    type Cause = zio.aws.elasticbeanstalk.model.primitives.Cause.Type
    object CnameAvailability extends Subtype[Boolean]
    type CnameAvailability =
      zio.aws.elasticbeanstalk.model.primitives.CnameAvailability.Type
    object ConfigurationOptionDefaultValue extends Subtype[String]
    type ConfigurationOptionDefaultValue =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionDefaultValue.Type
    object ConfigurationOptionName extends Subtype[String]
    type ConfigurationOptionName =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionName.Type
    object ConfigurationOptionPossibleValue extends Subtype[String]
    type ConfigurationOptionPossibleValue =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionPossibleValue.Type
    object ConfigurationOptionSeverity extends Subtype[String]
    type ConfigurationOptionSeverity =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionSeverity.Type
    object ConfigurationOptionValue extends Subtype[String]
    type ConfigurationOptionValue =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionValue.Type
    object ConfigurationTemplateName extends Subtype[String]
    type ConfigurationTemplateName =
      zio.aws.elasticbeanstalk.model.primitives.ConfigurationTemplateName.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate =
      zio.aws.elasticbeanstalk.model.primitives.CreationDate.Type
    object DNSCname extends Subtype[String]
    type DNSCname = zio.aws.elasticbeanstalk.model.primitives.DNSCname.Type
    object DNSCnamePrefix extends Subtype[String]
    type DNSCnamePrefix =
      zio.aws.elasticbeanstalk.model.primitives.DNSCnamePrefix.Type
    object DeleteSourceBundle extends Subtype[Boolean]
    type DeleteSourceBundle =
      zio.aws.elasticbeanstalk.model.primitives.DeleteSourceBundle.Type
    object DeploymentTimestamp extends Subtype[Instant]
    type DeploymentTimestamp =
      zio.aws.elasticbeanstalk.model.primitives.DeploymentTimestamp.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.elasticbeanstalk.model.primitives.Description.Type
    object Ec2InstanceId extends Subtype[String]
    type Ec2InstanceId =
      zio.aws.elasticbeanstalk.model.primitives.Ec2InstanceId.Type
    object EndpointURL extends Subtype[String]
    type EndpointURL =
      zio.aws.elasticbeanstalk.model.primitives.EndpointURL.Type
    object EnvironmentArn extends Subtype[String]
    type EnvironmentArn =
      zio.aws.elasticbeanstalk.model.primitives.EnvironmentArn.Type
    object EnvironmentId extends Subtype[String]
    type EnvironmentId =
      zio.aws.elasticbeanstalk.model.primitives.EnvironmentId.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName =
      zio.aws.elasticbeanstalk.model.primitives.EnvironmentName.Type
    object EventDate extends Subtype[Instant]
    type EventDate = zio.aws.elasticbeanstalk.model.primitives.EventDate.Type
    object EventMessage extends Subtype[String]
    type EventMessage =
      zio.aws.elasticbeanstalk.model.primitives.EventMessage.Type
    object FileTypeExtension extends Subtype[String]
    type FileTypeExtension =
      zio.aws.elasticbeanstalk.model.primitives.FileTypeExtension.Type
    object ForceTerminate extends Subtype[Boolean]
    type ForceTerminate =
      zio.aws.elasticbeanstalk.model.primitives.ForceTerminate.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.elasticbeanstalk.model.primitives.GroupName.Type
    object ImageId extends Subtype[String]
    type ImageId = zio.aws.elasticbeanstalk.model.primitives.ImageId.Type
    object IncludeDeleted extends Subtype[Boolean]
    type IncludeDeleted =
      zio.aws.elasticbeanstalk.model.primitives.IncludeDeleted.Type
    object IncludeDeletedBackTo extends Subtype[Instant]
    type IncludeDeletedBackTo =
      zio.aws.elasticbeanstalk.model.primitives.IncludeDeletedBackTo.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.elasticbeanstalk.model.primitives.InstanceId.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.elasticbeanstalk.model.primitives.Integer.Type
    object LaunchedAt extends Subtype[Instant]
    type LaunchedAt = zio.aws.elasticbeanstalk.model.primitives.LaunchedAt.Type
    object LoadAverageValue extends Subtype[Double]
    type LoadAverageValue =
      zio.aws.elasticbeanstalk.model.primitives.LoadAverageValue.Type
    object Maintainer extends Subtype[String]
    type Maintainer = zio.aws.elasticbeanstalk.model.primitives.Maintainer.Type
    object ManagedActionHistoryMaxItems extends Subtype[Int]
    type ManagedActionHistoryMaxItems =
      zio.aws.elasticbeanstalk.model.primitives.ManagedActionHistoryMaxItems.Type
    object MaxRecords extends Subtype[Int]
    type MaxRecords = zio.aws.elasticbeanstalk.model.primitives.MaxRecords.Type
    object Message extends Subtype[String]
    type Message = zio.aws.elasticbeanstalk.model.primitives.Message.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.elasticbeanstalk.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.elasticbeanstalk.model.primitives.NonEmptyString.Type
    object NullableDouble extends Subtype[Double]
    type NullableDouble =
      zio.aws.elasticbeanstalk.model.primitives.NullableDouble.Type
    object NullableInteger extends Subtype[Int]
    type NullableInteger =
      zio.aws.elasticbeanstalk.model.primitives.NullableInteger.Type
    object NullableLong extends Subtype[Long]
    type NullableLong =
      zio.aws.elasticbeanstalk.model.primitives.NullableLong.Type
    object OperatingSystemName extends Subtype[String]
    type OperatingSystemName =
      zio.aws.elasticbeanstalk.model.primitives.OperatingSystemName.Type
    object OperatingSystemVersion extends Subtype[String]
    type OperatingSystemVersion =
      zio.aws.elasticbeanstalk.model.primitives.OperatingSystemVersion.Type
    object OperationsRole extends Subtype[String]
    type OperationsRole =
      zio.aws.elasticbeanstalk.model.primitives.OperationsRole.Type
    object OptionNamespace extends Subtype[String]
    type OptionNamespace =
      zio.aws.elasticbeanstalk.model.primitives.OptionNamespace.Type
    object OptionRestrictionMaxLength extends Subtype[Int]
    type OptionRestrictionMaxLength =
      zio.aws.elasticbeanstalk.model.primitives.OptionRestrictionMaxLength.Type
    object OptionRestrictionMaxValue extends Subtype[Int]
    type OptionRestrictionMaxValue =
      zio.aws.elasticbeanstalk.model.primitives.OptionRestrictionMaxValue.Type
    object OptionRestrictionMinValue extends Subtype[Int]
    type OptionRestrictionMinValue =
      zio.aws.elasticbeanstalk.model.primitives.OptionRestrictionMinValue.Type
    object PlatformArn extends Subtype[String]
    type PlatformArn =
      zio.aws.elasticbeanstalk.model.primitives.PlatformArn.Type
    object PlatformBranchLifecycleState extends Subtype[String]
    type PlatformBranchLifecycleState =
      zio.aws.elasticbeanstalk.model.primitives.PlatformBranchLifecycleState.Type
    object PlatformBranchMaxRecords extends Subtype[Int]
    type PlatformBranchMaxRecords =
      zio.aws.elasticbeanstalk.model.primitives.PlatformBranchMaxRecords.Type
    object PlatformCategory extends Subtype[String]
    type PlatformCategory =
      zio.aws.elasticbeanstalk.model.primitives.PlatformCategory.Type
    object PlatformFilterOperator extends Subtype[String]
    type PlatformFilterOperator =
      zio.aws.elasticbeanstalk.model.primitives.PlatformFilterOperator.Type
    object PlatformFilterType extends Subtype[String]
    type PlatformFilterType =
      zio.aws.elasticbeanstalk.model.primitives.PlatformFilterType.Type
    object PlatformFilterValue extends Subtype[String]
    type PlatformFilterValue =
      zio.aws.elasticbeanstalk.model.primitives.PlatformFilterValue.Type
    object PlatformLifecycleState extends Subtype[String]
    type PlatformLifecycleState =
      zio.aws.elasticbeanstalk.model.primitives.PlatformLifecycleState.Type
    object PlatformMaxRecords extends Subtype[Int]
    type PlatformMaxRecords =
      zio.aws.elasticbeanstalk.model.primitives.PlatformMaxRecords.Type
    object PlatformName extends Subtype[String]
    type PlatformName =
      zio.aws.elasticbeanstalk.model.primitives.PlatformName.Type
    object PlatformOwner extends Subtype[String]
    type PlatformOwner =
      zio.aws.elasticbeanstalk.model.primitives.PlatformOwner.Type
    object PlatformVersion extends Subtype[String]
    type PlatformVersion =
      zio.aws.elasticbeanstalk.model.primitives.PlatformVersion.Type
    object RefreshedAt extends Subtype[Instant]
    type RefreshedAt =
      zio.aws.elasticbeanstalk.model.primitives.RefreshedAt.Type
    object RegexLabel extends Subtype[String]
    type RegexLabel = zio.aws.elasticbeanstalk.model.primitives.RegexLabel.Type
    object RegexPattern extends Subtype[String]
    type RegexPattern =
      zio.aws.elasticbeanstalk.model.primitives.RegexPattern.Type
    object RequestCount extends Subtype[Int]
    type RequestCount =
      zio.aws.elasticbeanstalk.model.primitives.RequestCount.Type
    object RequestId extends Subtype[String]
    type RequestId = zio.aws.elasticbeanstalk.model.primitives.RequestId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.elasticbeanstalk.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.elasticbeanstalk.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName =
      zio.aws.elasticbeanstalk.model.primitives.ResourceName.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.elasticbeanstalk.model.primitives.S3Bucket.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.elasticbeanstalk.model.primitives.S3Key.Type
    object SampleTimestamp extends Subtype[Instant]
    type SampleTimestamp =
      zio.aws.elasticbeanstalk.model.primitives.SampleTimestamp.Type
    object SearchFilterAttribute extends Subtype[String]
    type SearchFilterAttribute =
      zio.aws.elasticbeanstalk.model.primitives.SearchFilterAttribute.Type
    object SearchFilterOperator extends Subtype[String]
    type SearchFilterOperator =
      zio.aws.elasticbeanstalk.model.primitives.SearchFilterOperator.Type
    object SearchFilterValue extends Subtype[String]
    type SearchFilterValue =
      zio.aws.elasticbeanstalk.model.primitives.SearchFilterValue.Type
    object SolutionStackName extends Subtype[String]
    type SolutionStackName =
      zio.aws.elasticbeanstalk.model.primitives.SolutionStackName.Type
    object SourceLocation extends Subtype[String]
    type SourceLocation =
      zio.aws.elasticbeanstalk.model.primitives.SourceLocation.Type
    object SupportedAddon extends Subtype[String]
    type SupportedAddon =
      zio.aws.elasticbeanstalk.model.primitives.SupportedAddon.Type
    object SupportedTier extends Subtype[String]
    type SupportedTier =
      zio.aws.elasticbeanstalk.model.primitives.SupportedTier.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.elasticbeanstalk.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.elasticbeanstalk.model.primitives.TagValue.Type
    object TerminateEnvForce extends Subtype[Boolean]
    type TerminateEnvForce =
      zio.aws.elasticbeanstalk.model.primitives.TerminateEnvForce.Type
    object TerminateEnvironmentResources extends Subtype[Boolean]
    type TerminateEnvironmentResources =
      zio.aws.elasticbeanstalk.model.primitives.TerminateEnvironmentResources.Type
    object TimeFilterEnd extends Subtype[Instant]
    type TimeFilterEnd =
      zio.aws.elasticbeanstalk.model.primitives.TimeFilterEnd.Type
    object TimeFilterStart extends Subtype[Instant]
    type TimeFilterStart =
      zio.aws.elasticbeanstalk.model.primitives.TimeFilterStart.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.elasticbeanstalk.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.elasticbeanstalk.model.primitives.Token.Type
    object UpdateDate extends Subtype[Instant]
    type UpdateDate = zio.aws.elasticbeanstalk.model.primitives.UpdateDate.Type
    object UserDefinedOption extends Subtype[Boolean]
    type UserDefinedOption =
      zio.aws.elasticbeanstalk.model.primitives.UserDefinedOption.Type
    object ValidationMessageString extends Subtype[String]
    type ValidationMessageString =
      zio.aws.elasticbeanstalk.model.primitives.ValidationMessageString.Type
    object VersionLabel extends Subtype[String]
    type VersionLabel =
      zio.aws.elasticbeanstalk.model.primitives.VersionLabel.Type
    object VirtualizationType extends Subtype[String]
    type VirtualizationType =
      zio.aws.elasticbeanstalk.model.primitives.VirtualizationType.Type
  }
  type ApplicationDescriptionList =
    List[zio.aws.elasticbeanstalk.model.ApplicationDescription]
  type ApplicationNamesList = List[ApplicationName]
  type ApplicationVersionDescriptionList =
    List[zio.aws.elasticbeanstalk.model.ApplicationVersionDescription]
  type AutoScalingGroupList =
    List[zio.aws.elasticbeanstalk.model.AutoScalingGroup]
  type AvailableSolutionStackDetailsList =
    List[zio.aws.elasticbeanstalk.model.SolutionStackDescription]
  type AvailableSolutionStackNamesList = List[SolutionStackName]
  type Causes = List[Cause]
  type ConfigurationOptionDescriptionsList =
    List[zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription]
  type ConfigurationOptionPossibleValues =
    List[ConfigurationOptionPossibleValue]
  type ConfigurationOptionSettingsList =
    List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
  type ConfigurationSettingsDescriptionList =
    List[zio.aws.elasticbeanstalk.model.ConfigurationSettingsDescription]
  type ConfigurationTemplateNamesList = List[ConfigurationTemplateName]
  type CustomAmiList = List[zio.aws.elasticbeanstalk.model.CustomAmi]
  type EnvironmentDescriptionsList =
    List[zio.aws.elasticbeanstalk.model.EnvironmentDescription]
  type EnvironmentHealthAttributes =
    List[zio.aws.elasticbeanstalk.model.EnvironmentHealthAttribute]
  type EnvironmentIdList = List[EnvironmentId]
  type EnvironmentInfoDescriptionList =
    List[zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription]
  type EnvironmentLinks = List[zio.aws.elasticbeanstalk.model.EnvironmentLink]
  type EnvironmentNamesList = List[EnvironmentName]
  type EventDescriptionList =
    List[zio.aws.elasticbeanstalk.model.EventDescription]
  type InstanceHealthList =
    List[zio.aws.elasticbeanstalk.model.SingleInstanceHealth]
  type InstanceList = List[zio.aws.elasticbeanstalk.model.Instance]
  type InstancesHealthAttributes =
    List[zio.aws.elasticbeanstalk.model.InstancesHealthAttribute]
  type LaunchConfigurationList =
    List[zio.aws.elasticbeanstalk.model.LaunchConfiguration]
  type LaunchTemplateList = List[zio.aws.elasticbeanstalk.model.LaunchTemplate]
  type LoadAverage = List[LoadAverageValue]
  type LoadBalancerList = List[zio.aws.elasticbeanstalk.model.LoadBalancer]
  type LoadBalancerListenersDescription =
    List[zio.aws.elasticbeanstalk.model.Listener]
  type ManagedActionHistoryItems =
    List[zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem]
  type ManagedActions = List[zio.aws.elasticbeanstalk.model.ManagedAction]
  type OptionsSpecifierList =
    List[zio.aws.elasticbeanstalk.model.OptionSpecification]
  type PlatformBranchSummaryList =
    List[zio.aws.elasticbeanstalk.model.PlatformBranchSummary]
  type PlatformFilterValueList = List[PlatformFilterValue]
  type PlatformFilters = List[zio.aws.elasticbeanstalk.model.PlatformFilter]
  type PlatformFrameworks =
    List[zio.aws.elasticbeanstalk.model.PlatformFramework]
  type PlatformProgrammingLanguages =
    List[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage]
  type PlatformSummaryList =
    List[zio.aws.elasticbeanstalk.model.PlatformSummary]
  type QueueList = List[zio.aws.elasticbeanstalk.model.Queue]
  type SearchFilterValues = List[SearchFilterValue]
  type SearchFilters = List[zio.aws.elasticbeanstalk.model.SearchFilter]
  type SolutionStackFileTypeList = List[FileTypeExtension]
  type SupportedAddonList = List[SupportedAddon]
  type SupportedTierList = List[SupportedTier]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.elasticbeanstalk.model.Tag]
  type Tags = List[zio.aws.elasticbeanstalk.model.Tag]
  type TriggerList = List[zio.aws.elasticbeanstalk.model.Trigger]
  type ValidationMessagesList =
    List[zio.aws.elasticbeanstalk.model.ValidationMessage]
  type VersionLabels = List[VersionLabel]
  type VersionLabelsList = List[VersionLabel]
}
