package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListPlatformBranchesResponse(
    platformBranchSummaryList: Option[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformBranchSummary]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse = {
    import ListPlatformBranchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse
      .builder()
      .optionallyWith(
        platformBranchSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformBranchSummaryList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse
      .wrap(buildAwsValue())
}
object ListPlatformBranchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse =
      zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse(
        platformBranchSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def platformBranchSummaryList: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getPlatformBranchSummaryList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "platformBranchSummaryList",
      platformBranchSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly {
    override val platformBranchSummaryList: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformBranchSummary.ReadOnly]
    ] = scala
      .Option(impl.platformBranchSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformBranchSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse
  ): zio.aws.elasticbeanstalk.model.ListPlatformBranchesResponse.ReadOnly =
    new Wrapper(impl)
}
