package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.BoxedInt
import scala.jdk.CollectionConverters._
final case class ResourceQuota(maximum: Option[BoxedInt] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota = {
    import ResourceQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
      .builder()
      .optionallyWith(maximum.map(value => BoxedInt.unwrap(value): Integer))(
        _.maximum
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly =
    zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(buildAwsValue())
}
object ResourceQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ResourceQuota =
      zio.aws.elasticbeanstalk.model.ResourceQuota(maximum.map(value => value))
    def maximum: Option[BoxedInt]
    def getMaximum: ZIO[Any, AwsError, BoxedInt] =
      AwsError.unwrapOptionField("maximum", maximum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ) extends zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly {
    override val maximum: Option[BoxedInt] = scala
      .Option(impl.maximum())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.BoxedInt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ): zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly = new Wrapper(impl)
}
