package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.NullableDouble
import scala.jdk.CollectionConverters._
final case class Latency(
    p999: Option[NullableDouble] = None,
    p99: Option[NullableDouble] = None,
    p95: Option[NullableDouble] = None,
    p90: Option[NullableDouble] = None,
    p85: Option[NullableDouble] = None,
    p75: Option[NullableDouble] = None,
    p50: Option[NullableDouble] = None,
    p10: Option[NullableDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Latency = {
    import Latency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Latency
      .builder()
      .optionallyWith(
        p999.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p999)
      .optionallyWith(
        p99.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p99)
      .optionallyWith(
        p95.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p95)
      .optionallyWith(
        p90.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p90)
      .optionallyWith(
        p85.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p85)
      .optionallyWith(
        p75.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p75)
      .optionallyWith(
        p50.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p50)
      .optionallyWith(
        p10.map(value => NullableDouble.unwrap(value): java.lang.Double)
      )(_.p10)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Latency.ReadOnly =
    zio.aws.elasticbeanstalk.model.Latency.wrap(buildAwsValue())
}
object Latency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Latency =
      zio.aws.elasticbeanstalk.model.Latency(
        p999.map(value => value),
        p99.map(value => value),
        p95.map(value => value),
        p90.map(value => value),
        p85.map(value => value),
        p75.map(value => value),
        p50.map(value => value),
        p10.map(value => value)
      )
    def p999: Option[NullableDouble]
    def p99: Option[NullableDouble]
    def p95: Option[NullableDouble]
    def p90: Option[NullableDouble]
    def p85: Option[NullableDouble]
    def p75: Option[NullableDouble]
    def p50: Option[NullableDouble]
    def p10: Option[NullableDouble]
    def getP999: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p999", p999)
    def getP99: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p99", p99)
    def getP95: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p95", p95)
    def getP90: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p90", p90)
    def getP85: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p85", p85)
    def getP75: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p75", p75)
    def getP50: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p50", p50)
    def getP10: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("p10", p10)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ) extends zio.aws.elasticbeanstalk.model.Latency.ReadOnly {
    override val p999: Option[NullableDouble] = scala
      .Option(impl.p999())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p99: Option[NullableDouble] = scala
      .Option(impl.p99())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p95: Option[NullableDouble] = scala
      .Option(impl.p95())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p90: Option[NullableDouble] = scala
      .Option(impl.p90())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p85: Option[NullableDouble] = scala
      .Option(impl.p85())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p75: Option[NullableDouble] = scala
      .Option(impl.p75())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p50: Option[NullableDouble] = scala
      .Option(impl.p50())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
    override val p10: Option[NullableDouble] = scala
      .Option(impl.p10())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.NullableDouble(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Latency
  ): zio.aws.elasticbeanstalk.model.Latency.ReadOnly = new Wrapper(impl)
}
