package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters._
final case class RestartAppServerRequest(
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest = {
    import RestartAppServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.RestartAppServerRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.RestartAppServerRequest.wrap(buildAwsValue())
}
object RestartAppServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.RestartAppServerRequest =
      zio.aws.elasticbeanstalk.model.RestartAppServerRequest(
        environmentId.map(value => value),
        environmentName.map(value => value)
      )
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest
  ) extends zio.aws.elasticbeanstalk.model.RestartAppServerRequest.ReadOnly {
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest
  ): zio.aws.elasticbeanstalk.model.RestartAppServerRequest.ReadOnly =
    new Wrapper(impl)
}
