package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionValue,
  ConfigurationOptionName,
  OptionNamespace,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class ConfigurationOptionSetting(
    resourceName: Option[ResourceName] = None,
    namespace: Option[OptionNamespace] = None,
    optionName: Option[ConfigurationOptionName] = None,
    value: Option[ConfigurationOptionValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting = {
    import ConfigurationOptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        optionName.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.optionName)
      .optionallyWith(
        value.map(value =>
          ConfigurationOptionValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly =
    zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting
      .wrap(buildAwsValue())
}
object ConfigurationOptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting =
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting(
        resourceName.map(value => value),
        namespace.map(value => value),
        optionName.map(value => value),
        value.map(value => value)
      )
    def resourceName: Option[ResourceName]
    def namespace: Option[OptionNamespace]
    def optionName: Option[ConfigurationOptionName]
    def value: Option[ConfigurationOptionValue]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOptionName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("optionName", optionName)
    def getValue: ZIO[Any, AwsError, ConfigurationOptionValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting
  ) extends zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly {
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ResourceName(value)
      )
    override val namespace: Option[OptionNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val optionName: Option[ConfigurationOptionName] = scala
      .Option(impl.optionName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionName(value)
      )
    override val value: Option[ConfigurationOptionValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationOptionValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting
  ): zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly =
    new Wrapper(impl)
}
