package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationDeploymentStatus {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus
}
object ConfigurationDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus
  ): zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus =
    value match {
      case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.DEPLOYED =>
        val r = deployed
        r
      case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.PENDING =>
        val r = pending
        r
      case software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.FAILED =>
        val r = failed
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object deployed
      extends zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.DEPLOYED
  }
  case object pending
      extends zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.PENDING
  }
  case object failed
      extends zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus.FAILED
  }
}
