package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait TransitEncryptionMode {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode
}
object TransitEncryptionMode {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode
  ): zio.aws.elasticache.model.TransitEncryptionMode = value match {
    case software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.PREFERRED =>
      val r = preferred
      r
    case software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.TransitEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode =
      software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object preferred
      extends zio.aws.elasticache.model.TransitEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode =
      software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.PREFERRED
  }
  case object required extends zio.aws.elasticache.model.TransitEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode =
      software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode.REQUIRED
  }
}
