package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartMigrationRequest(
    replicationGroupId: String,
    customerNodeEndpointList: Iterable[
      zio.aws.elasticache.model.CustomerNodeEndpoint
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.StartMigrationRequest = {
    import StartMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.StartMigrationRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .customerNodeEndpointList(customerNodeEndpointList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.StartMigrationRequest.ReadOnly =
    zio.aws.elasticache.model.StartMigrationRequest.wrap(buildAwsValue())
}
object StartMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.StartMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.StartMigrationRequest =
      zio.aws.elasticache.model.StartMigrationRequest(
        replicationGroupId,
        customerNodeEndpointList.map { item =>
          item.asEditable
        }
      )
    def replicationGroupId: String
    def customerNodeEndpointList
        : List[zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getCustomerNodeEndpointList: ZIO[Any, Nothing, List[
      zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly
    ]] = ZIO.succeed(customerNodeEndpointList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.StartMigrationRequest
  ) extends zio.aws.elasticache.model.StartMigrationRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val customerNodeEndpointList
        : List[zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly] = impl
      .customerNodeEndpointList()
      .asScala
      .map { item =>
        zio.aws.elasticache.model.CustomerNodeEndpoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.StartMigrationRequest
  ): zio.aws.elasticache.model.StartMigrationRequest.ReadOnly = new Wrapper(
    impl
  )
}
