package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait PendingAutomaticFailoverStatus {
  def unwrap: software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus
}
object PendingAutomaticFailoverStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus
  ): zio.aws.elasticache.model.PendingAutomaticFailoverStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.PendingAutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled
      extends zio.aws.elasticache.model.PendingAutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.ENABLED
  }
  case object disabled
      extends zio.aws.elasticache.model.PendingAutomaticFailoverStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus =
      software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus.DISABLED
  }
}
