package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NodeGroupUpdateStatus(
    nodeGroupId: Optional[String] = Optional.Absent,
    nodeGroupMemberUpdateStatus: Optional[
      Iterable[zio.aws.elasticache.model.NodeGroupMemberUpdateStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus = {
    import NodeGroupUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus
      .builder()
      .optionallyWith(nodeGroupId.map(value => value: java.lang.String))(
        _.nodeGroupId
      )
      .optionallyWith(
        nodeGroupMemberUpdateStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupMemberUpdateStatus)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly =
    zio.aws.elasticache.model.NodeGroupUpdateStatus.wrap(buildAwsValue())
}
object NodeGroupUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupUpdateStatus =
      zio.aws.elasticache.model.NodeGroupUpdateStatus(
        nodeGroupId.map(value => value),
        nodeGroupMemberUpdateStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nodeGroupId: Optional[String]
    def nodeGroupMemberUpdateStatus: Optional[
      List[zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly]
    ]
    def getNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getNodeGroupMemberUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeGroupMemberUpdateStatus",
      nodeGroupMemberUpdateStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus
  ) extends zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly {
    override val nodeGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupId())
      .map(value => value: String)
    override val nodeGroupMemberUpdateStatus: Optional[
      List[zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupMemberUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupUpdateStatus
  ): zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly = new Wrapper(
    impl
  )
}
