package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{
  BooleanOptional,
  AccessString,
  UserId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyUserRequest(
    userId: UserId,
    accessString: Optional[AccessString] = Optional.Absent,
    appendAccessString: Optional[AccessString] = Optional.Absent,
    passwords: Optional[Iterable[String]] = Optional.Absent,
    noPasswordRequired: Optional[BooleanOptional] = Optional.Absent,
    authenticationMode: Optional[zio.aws.elasticache.model.AuthenticationMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyUserRequest = {
    import ModifyUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        accessString.map(value => AccessString.unwrap(value): java.lang.String)
      )(_.accessString)
      .optionallyWith(
        appendAccessString.map(value =>
          AccessString.unwrap(value): java.lang.String
        )
      )(_.appendAccessString)
      .optionallyWith(
        passwords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.passwords)
      .optionallyWith(
        noPasswordRequired.map(value => value: java.lang.Boolean)
      )(_.noPasswordRequired)
      .optionallyWith(authenticationMode.map(value => value.buildAwsValue()))(
        _.authenticationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyUserRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyUserRequest.wrap(buildAwsValue())
}
object ModifyUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyUserRequest =
      zio.aws.elasticache.model.ModifyUserRequest(
        userId,
        accessString.map(value => value),
        appendAccessString.map(value => value),
        passwords.map(value => value),
        noPasswordRequired.map(value => value),
        authenticationMode.map(value => value.asEditable)
      )
    def userId: UserId
    def accessString: Optional[AccessString]
    def appendAccessString: Optional[AccessString]
    def passwords: Optional[List[String]]
    def noPasswordRequired: Optional[BooleanOptional]
    def authenticationMode
        : Optional[zio.aws.elasticache.model.AuthenticationMode.ReadOnly]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getAccessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getAppendAccessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("appendAccessString", appendAccessString)
    def getPasswords: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("passwords", passwords)
    def getNoPasswordRequired: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noPasswordRequired", noPasswordRequired)
    def getAuthenticationMode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AuthenticationMode.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationMode", authenticationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ) extends zio.aws.elasticache.model.ModifyUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.elasticache.model.primitives.UserId(impl.userId())
    override val accessString: Optional[AccessString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessString())
      .map(value => zio.aws.elasticache.model.primitives.AccessString(value))
    override val appendAccessString: Optional[AccessString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appendAccessString())
        .map(value => zio.aws.elasticache.model.primitives.AccessString(value))
    override val passwords: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.passwords())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val noPasswordRequired: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noPasswordRequired())
        .map(value => value: BooleanOptional)
    override val authenticationMode
        : Optional[zio.aws.elasticache.model.AuthenticationMode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationMode())
        .map(value => zio.aws.elasticache.model.AuthenticationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ): zio.aws.elasticache.model.ModifyUserRequest.ReadOnly = new Wrapper(impl)
}
