package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait DestinationType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.DestinationType
}
object DestinationType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.DestinationType
  ): zio.aws.elasticache.model.DestinationType = value match {
    case software.amazon.awssdk.services.elasticache.model.DestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.DestinationType.CLOUDWATCH_LOGS =>
      val r = `cloudwatch-logs`
      r
    case software.amazon.awssdk.services.elasticache.model.DestinationType.KINESIS_FIREHOSE =>
      val r = `kinesis-firehose`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DestinationType =
      software.amazon.awssdk.services.elasticache.model.DestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object `cloudwatch-logs`
      extends zio.aws.elasticache.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DestinationType =
      software.amazon.awssdk.services.elasticache.model.DestinationType.CLOUDWATCH_LOGS
  }
  case object `kinesis-firehose`
      extends zio.aws.elasticache.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DestinationType =
      software.amazon.awssdk.services.elasticache.model.DestinationType.KINESIS_FIREHOSE
  }
}
