package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterMode {
  def unwrap: software.amazon.awssdk.services.elasticache.model.ClusterMode
}
object ClusterMode {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.ClusterMode
  ): zio.aws.elasticache.model.ClusterMode = value match {
    case software.amazon.awssdk.services.elasticache.model.ClusterMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.ClusterMode.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.elasticache.model.ClusterMode.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.elasticache.model.ClusterMode.COMPATIBLE =>
      val r = compatible
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.ClusterMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ClusterMode =
      software.amazon.awssdk.services.elasticache.model.ClusterMode.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.elasticache.model.ClusterMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ClusterMode =
      software.amazon.awssdk.services.elasticache.model.ClusterMode.ENABLED
  }
  case object disabled extends zio.aws.elasticache.model.ClusterMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ClusterMode =
      software.amazon.awssdk.services.elasticache.model.ClusterMode.DISABLED
  }
  case object compatible extends zio.aws.elasticache.model.ClusterMode {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ClusterMode =
      software.amazon.awssdk.services.elasticache.model.ClusterMode.COMPATIBLE
  }
}
