package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchStopUpdateActionRequest(
    replicationGroupIds: Optional[Iterable[String]] = Optional.Absent,
    cacheClusterIds: Optional[Iterable[String]] = Optional.Absent,
    serviceUpdateName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest = {
    import BatchStopUpdateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
      .builder()
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .serviceUpdateName(serviceUpdateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly =
    zio.aws.elasticache.model.BatchStopUpdateActionRequest.wrap(buildAwsValue())
}
object BatchStopUpdateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchStopUpdateActionRequest =
      zio.aws.elasticache.model.BatchStopUpdateActionRequest(
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        serviceUpdateName
      )
    def replicationGroupIds: Optional[List[String]]
    def cacheClusterIds: Optional[List[String]]
    def serviceUpdateName: String
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getServiceUpdateName: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceUpdateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ) extends zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly {
    override val replicationGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val cacheClusterIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceUpdateName: String = impl.serviceUpdateName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ): zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly =
    new Wrapper(impl)
}
