package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedUpdateAction(
    replicationGroupId: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    serviceUpdateName: Optional[String] = Optional.Absent,
    errorType: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction = {
    import UnprocessedUpdateAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(errorType.map(value => value: java.lang.String))(
        _.errorType
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly =
    zio.aws.elasticache.model.UnprocessedUpdateAction.wrap(buildAwsValue())
}
object UnprocessedUpdateAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UnprocessedUpdateAction =
      zio.aws.elasticache.model.UnprocessedUpdateAction(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        serviceUpdateName.map(value => value),
        errorType.map(value => value),
        errorMessage.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def cacheClusterId: Optional[String]
    def serviceUpdateName: Optional[String]
    def errorType: Optional[String]
    def errorMessage: Optional[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getErrorType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction
  ) extends zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val errorType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction
  ): zio.aws.elasticache.model.UnprocessedUpdateAction.ReadOnly = new Wrapper(
    impl
  )
}
