package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebalanceSlotsInGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest = {
    import RebalanceSlotsInGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object RebalanceSlotsInGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest(
        globalReplicationGroupId,
        applyImmediately
      )
    def globalReplicationGroupId: String
    def applyImmediately: Boolean
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
