package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  IntegerOptional,
  BooleanOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationGroupRequest(
    replicationGroupId: String,
    replicationGroupDescription: Optional[String] = Optional.Absent,
    primaryClusterId: Optional[String] = Optional.Absent,
    snapshottingClusterId: Optional[String] = Optional.Absent,
    automaticFailoverEnabled: Optional[BooleanOptional] = Optional.Absent,
    multiAZEnabled: Optional[BooleanOptional] = Optional.Absent,
    nodeGroupId: Optional[String] = Optional.Absent,
    cacheSecurityGroupNames: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    notificationTopicArn: Optional[String] = Optional.Absent,
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    notificationTopicStatus: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    authToken: Optional[String] = Optional.Absent,
    authTokenUpdateStrategy: Optional[
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = Optional.Absent,
    userGroupIdsToAdd: Optional[Iterable[UserGroupId]] = Optional.Absent,
    userGroupIdsToRemove: Optional[Iterable[UserGroupId]] = Optional.Absent,
    removeUserGroups: Optional[BooleanOptional] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = Optional.Absent,
    ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    transitEncryptionMode: Optional[
      zio.aws.elasticache.model.TransitEncryptionMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest = {
    import ModifyReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(
        replicationGroupDescription.map(value => value: java.lang.String)
      )(_.replicationGroupDescription)
      .optionallyWith(primaryClusterId.map(value => value: java.lang.String))(
        _.primaryClusterId
      )
      .optionallyWith(
        snapshottingClusterId.map(value => value: java.lang.String)
      )(_.snapshottingClusterId)
      .optionallyWith(
        automaticFailoverEnabled.map(value => value: java.lang.Boolean)
      )(_.automaticFailoverEnabled)
      .optionallyWith(multiAZEnabled.map(value => value: java.lang.Boolean))(
        _.multiAZEnabled
      )
      .optionallyWith(nodeGroupId.map(value => value: java.lang.String))(
        _.nodeGroupId
      )
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        notificationTopicStatus.map(value => value: java.lang.String)
      )(_.notificationTopicStatus)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(authTokenUpdateStrategy.map(value => value.unwrap))(
        _.authTokenUpdateStrategy
      )
      .optionallyWith(
        userGroupIdsToAdd.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToAdd)
      .optionallyWith(
        userGroupIdsToRemove.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToRemove)
      .optionallyWith(removeUserGroups.map(value => value: java.lang.Boolean))(
        _.removeUserGroups
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(ipDiscovery.map(value => value.unwrap))(_.ipDiscovery)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(transitEncryptionMode.map(value => value.unwrap))(
        _.transitEncryptionMode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyReplicationGroupRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyReplicationGroupRequest =
      zio.aws.elasticache.model.ModifyReplicationGroupRequest(
        replicationGroupId,
        replicationGroupDescription.map(value => value),
        primaryClusterId.map(value => value),
        snapshottingClusterId.map(value => value),
        automaticFailoverEnabled.map(value => value),
        multiAZEnabled.map(value => value),
        nodeGroupId.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        cacheParameterGroupName.map(value => value),
        notificationTopicStatus.map(value => value),
        applyImmediately.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        cacheNodeType.map(value => value),
        authToken.map(value => value),
        authTokenUpdateStrategy.map(value => value),
        userGroupIdsToAdd.map(value => value),
        userGroupIdsToRemove.map(value => value),
        removeUserGroups.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipDiscovery.map(value => value),
        transitEncryptionEnabled.map(value => value),
        transitEncryptionMode.map(value => value)
      )
    def replicationGroupId: String
    def replicationGroupDescription: Optional[String]
    def primaryClusterId: Optional[String]
    def snapshottingClusterId: Optional[String]
    def automaticFailoverEnabled: Optional[BooleanOptional]
    def multiAZEnabled: Optional[BooleanOptional]
    def nodeGroupId: Optional[String]
    def cacheSecurityGroupNames: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def preferredMaintenanceWindow: Optional[String]
    def notificationTopicArn: Optional[String]
    def cacheParameterGroupName: Optional[String]
    def notificationTopicStatus: Optional[String]
    def applyImmediately: Optional[Boolean]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def cacheNodeType: Optional[String]
    def authToken: Optional[String]
    def authTokenUpdateStrategy
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStrategyType]
    def userGroupIdsToAdd: Optional[List[UserGroupId]]
    def userGroupIdsToRemove: Optional[List[UserGroupId]]
    def removeUserGroups: Optional[BooleanOptional]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationGroupDescription",
        replicationGroupDescription
      )
    def getPrimaryClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryClusterId", primaryClusterId)
    def getSnapshottingClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshottingClusterId", snapshottingClusterId)
    def getAutomaticFailoverEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "automaticFailoverEnabled",
        automaticFailoverEnabled
      )
    def getMultiAZEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZEnabled", multiAZEnabled)
    def getNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getNotificationTopicStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("notificationTopicStatus", notificationTopicStatus)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getAuthTokenUpdateStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = AwsError.unwrapOptionField(
      "authTokenUpdateStrategy",
      authTokenUpdateStrategy
    )
    def getUserGroupIdsToAdd: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToAdd", userGroupIdsToAdd)
    def getUserGroupIdsToRemove: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToRemove", userGroupIdsToRemove)
    def getRemoveUserGroups: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("removeUserGroups", removeUserGroups)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getIpDiscovery
        : ZIO[Any, AwsError, zio.aws.elasticache.model.IpDiscovery] =
      AwsError.unwrapOptionField("ipDiscovery", ipDiscovery)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getTransitEncryptionMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.TransitEncryptionMode] =
      AwsError.unwrapOptionField("transitEncryptionMode", transitEncryptionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ) extends zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupDescription())
        .map(value => value: String)
    override val primaryClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryClusterId())
      .map(value => value: String)
    override val snapshottingClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshottingClusterId())
      .map(value => value: String)
    override val automaticFailoverEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automaticFailoverEnabled())
        .map(value => value: BooleanOptional)
    override val multiAZEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiAZEnabled())
        .map(value => value: BooleanOptional)
    override val nodeGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupId())
      .map(value => value: String)
    override val cacheSecurityGroupNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val notificationTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationTopicArn())
      .map(value => value: String)
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val notificationTopicStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTopicStatus())
        .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val authToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authToken())
      .map(value => value: String)
    override val authTokenUpdateStrategy
        : Optional[zio.aws.elasticache.model.AuthTokenUpdateStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenUpdateStrategy())
        .map(value =>
          zio.aws.elasticache.model.AuthTokenUpdateStrategyType.wrap(value)
        )
    override val userGroupIdsToAdd: Optional[List[UserGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroupIdsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.primitives.UserGroupId(item)
          }.toList
        )
    override val userGroupIdsToRemove: Optional[List[UserGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroupIdsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.primitives.UserGroupId(item)
          }.toList
        )
    override val removeUserGroups: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeUserGroups())
        .map(value => value: BooleanOptional)
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
    override val ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipDiscovery())
        .map(value => zio.aws.elasticache.model.IpDiscovery.wrap(value))
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionMode())
        .map(value =>
          zio.aws.elasticache.model.TransitEncryptionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ): zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
