package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DecreaseReplicaCountResponse(
    replicationGroup: Optional[zio.aws.elasticache.model.ReplicationGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse = {
    import DecreaseReplicaCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse
      .builder()
      .optionallyWith(replicationGroup.map(value => value.buildAwsValue()))(
        _.replicationGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly =
    zio.aws.elasticache.model.DecreaseReplicaCountResponse.wrap(buildAwsValue())
}
object DecreaseReplicaCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DecreaseReplicaCountResponse =
      zio.aws.elasticache.model.DecreaseReplicaCountResponse(
        replicationGroup.map(value => value.asEditable)
      )
    def replicationGroup
        : Optional[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
    def getReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse
  ) extends zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly {
    override val replicationGroup
        : Optional[zio.aws.elasticache.model.ReplicationGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroup())
        .map(value => zio.aws.elasticache.model.ReplicationGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse
  ): zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly =
    new Wrapper(impl)
}
