package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CacheSecurityGroupMembership(
    cacheSecurityGroupName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership = {
    import CacheSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership
      .builder()
      .optionallyWith(
        cacheSecurityGroupName.map(value => value: java.lang.String)
      )(_.cacheSecurityGroupName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly =
    zio.aws.elasticache.model.CacheSecurityGroupMembership.wrap(buildAwsValue())
}
object CacheSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheSecurityGroupMembership =
      zio.aws.elasticache.model.CacheSecurityGroupMembership(
        cacheSecurityGroupName.map(value => value),
        status.map(value => value)
      )
    def cacheSecurityGroupName: Optional[String]
    def status: Optional[String]
    def getCacheSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheSecurityGroupName", cacheSecurityGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership
  ) extends zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly {
    override val cacheSecurityGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupName())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership
  ): zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly =
    new Wrapper(impl)
}
