package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  BooleanOptional,
  TStamp,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CacheCluster(
    cacheClusterId: Optional[String] = Optional.Absent,
    configurationEndpoint: Optional[zio.aws.elasticache.model.Endpoint] =
      Optional.Absent,
    clientDownloadLandingPage: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    cacheClusterStatus: Optional[String] = Optional.Absent,
    numCacheNodes: Optional[IntegerOptional] = Optional.Absent,
    preferredAvailabilityZone: Optional[String] = Optional.Absent,
    preferredOutpostArn: Optional[String] = Optional.Absent,
    cacheClusterCreateTime: Optional[TStamp] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.elasticache.model.PendingModifiedValues
    ] = Optional.Absent,
    notificationConfiguration: Optional[
      zio.aws.elasticache.model.NotificationConfiguration
    ] = Optional.Absent,
    cacheSecurityGroups: Optional[
      Iterable[zio.aws.elasticache.model.CacheSecurityGroupMembership]
    ] = Optional.Absent,
    cacheParameterGroup: Optional[
      zio.aws.elasticache.model.CacheParameterGroupStatus
    ] = Optional.Absent,
    cacheSubnetGroupName: Optional[String] = Optional.Absent,
    cacheNodes: Optional[Iterable[zio.aws.elasticache.model.CacheNode]] =
      Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    securityGroups: Optional[
      Iterable[zio.aws.elasticache.model.SecurityGroupMembership]
    ] = Optional.Absent,
    replicationGroupId: Optional[String] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    authTokenEnabled: Optional[BooleanOptional] = Optional.Absent,
    authTokenLastModifiedDate: Optional[TStamp] = Optional.Absent,
    transitEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    atRestEncryptionEnabled: Optional[BooleanOptional] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    replicationGroupLogDeliveryEnabled: Optional[Boolean] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfiguration]
    ] = Optional.Absent,
    networkType: Optional[zio.aws.elasticache.model.NetworkType] =
      Optional.Absent,
    ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      Optional.Absent,
    transitEncryptionMode: Optional[
      zio.aws.elasticache.model.TransitEncryptionMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheCluster = {
    import CacheCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheCluster
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(
        configurationEndpoint.map(value => value.buildAwsValue())
      )(_.configurationEndpoint)
      .optionallyWith(
        clientDownloadLandingPage.map(value => value: java.lang.String)
      )(_.clientDownloadLandingPage)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(cacheClusterStatus.map(value => value: java.lang.String))(
        _.cacheClusterStatus
      )
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        cacheClusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheClusterCreateTime)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .optionallyWith(
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheSecurityGroups)
      .optionallyWith(cacheParameterGroup.map(value => value.buildAwsValue()))(
        _.cacheParameterGroup
      )
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodes)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        authTokenLastModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.authTokenLastModifiedDate)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        replicationGroupLogDeliveryEnabled.map(value =>
          value: java.lang.Boolean
        )
      )(_.replicationGroupLogDeliveryEnabled)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(networkType.map(value => value.unwrap))(_.networkType)
      .optionallyWith(ipDiscovery.map(value => value.unwrap))(_.ipDiscovery)
      .optionallyWith(transitEncryptionMode.map(value => value.unwrap))(
        _.transitEncryptionMode
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheCluster.ReadOnly =
    zio.aws.elasticache.model.CacheCluster.wrap(buildAwsValue())
}
object CacheCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheCluster =
      zio.aws.elasticache.model.CacheCluster(
        cacheClusterId.map(value => value),
        configurationEndpoint.map(value => value.asEditable),
        clientDownloadLandingPage.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheClusterStatus.map(value => value),
        numCacheNodes.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        cacheClusterCreateTime.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        notificationConfiguration.map(value => value.asEditable),
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheParameterGroup.map(value => value.asEditable),
        cacheSubnetGroupName.map(value => value),
        cacheNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoMinorVersionUpgrade.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationGroupId.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authTokenEnabled.map(value => value),
        authTokenLastModifiedDate.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        arn.map(value => value),
        replicationGroupLogDeliveryEnabled.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkType.map(value => value),
        ipDiscovery.map(value => value),
        transitEncryptionMode.map(value => value)
      )
    def cacheClusterId: Optional[String]
    def configurationEndpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def clientDownloadLandingPage: Optional[String]
    def cacheNodeType: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def cacheClusterStatus: Optional[String]
    def numCacheNodes: Optional[IntegerOptional]
    def preferredAvailabilityZone: Optional[String]
    def preferredOutpostArn: Optional[String]
    def cacheClusterCreateTime: Optional[TStamp]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues
        : Optional[zio.aws.elasticache.model.PendingModifiedValues.ReadOnly]
    def notificationConfiguration
        : Optional[zio.aws.elasticache.model.NotificationConfiguration.ReadOnly]
    def cacheSecurityGroups: Optional[
      List[zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly]
    ]
    def cacheParameterGroup
        : Optional[zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly]
    def cacheSubnetGroupName: Optional[String]
    def cacheNodes: Optional[List[zio.aws.elasticache.model.CacheNode.ReadOnly]]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def securityGroups: Optional[
      List[zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly]
    ]
    def replicationGroupId: Optional[String]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def authTokenEnabled: Optional[BooleanOptional]
    def authTokenLastModifiedDate: Optional[TStamp]
    def transitEncryptionEnabled: Optional[BooleanOptional]
    def atRestEncryptionEnabled: Optional[BooleanOptional]
    def arn: Optional[String]
    def replicationGroupLogDeliveryEnabled: Optional[Boolean]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ]
    def networkType: Optional[zio.aws.elasticache.model.NetworkType]
    def ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery]
    def transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getConfigurationEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("configurationEndpoint", configurationEndpoint)
    def getClientDownloadLandingPage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clientDownloadLandingPage", clientDownloadLandingPage)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCacheClusterCreateTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("cacheClusterCreateTime", cacheClusterCreateTime)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
    def getCacheSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheSecurityGroups", cacheSecurityGroups)
    def getCacheParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly
    ] = AwsError.unwrapOptionField("cacheParameterGroup", cacheParameterGroup)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheNodes: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNode.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheNodes", cacheNodes)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getAuthTokenLastModifiedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("authTokenLastModifiedDate", authTokenLastModifiedDate)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getReplicationGroupLogDeliveryEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "replicationGroupLogDeliveryEnabled",
        replicationGroupLogDeliveryEnabled
      )
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getNetworkType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NetworkType] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getIpDiscovery
        : ZIO[Any, AwsError, zio.aws.elasticache.model.IpDiscovery] =
      AwsError.unwrapOptionField("ipDiscovery", ipDiscovery)
    def getTransitEncryptionMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.TransitEncryptionMode] =
      AwsError.unwrapOptionField("transitEncryptionMode", transitEncryptionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheCluster
  ) extends zio.aws.elasticache.model.CacheCluster.ReadOnly {
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val configurationEndpoint
        : Optional[zio.aws.elasticache.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationEndpoint())
        .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val clientDownloadLandingPage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientDownloadLandingPage())
        .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val cacheClusterStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterStatus())
      .map(value => value: String)
    override val numCacheNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheNodes())
        .map(value => value: IntegerOptional)
    override val preferredAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZone())
        .map(value => value: String)
    override val preferredOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredOutpostArn())
      .map(value => value: String)
    override val cacheClusterCreateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterCreateTime())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues
        : Optional[zio.aws.elasticache.model.PendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value =>
          zio.aws.elasticache.model.PendingModifiedValues.wrap(value)
        )
    override val notificationConfiguration: Optional[
      zio.aws.elasticache.model.NotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationConfiguration())
      .map(value =>
        zio.aws.elasticache.model.NotificationConfiguration.wrap(value)
      )
    override val cacheSecurityGroups: Optional[
      List[zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val cacheParameterGroup: Optional[
      zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheParameterGroup())
      .map(value =>
        zio.aws.elasticache.model.CacheParameterGroupStatus.wrap(value)
      )
    override val cacheSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSubnetGroupName())
      .map(value => value: String)
    override val cacheNodes
        : Optional[List[zio.aws.elasticache.model.CacheNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.CacheNode.wrap(item)
          }.toList
        )
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val securityGroups: Optional[
      List[zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.SecurityGroupMembership.wrap(item)
        }.toList
      )
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val authTokenEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenEnabled())
        .map(value => value: BooleanOptional)
    override val authTokenLastModifiedDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authTokenLastModifiedDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val transitEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: BooleanOptional)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val replicationGroupLogDeliveryEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationGroupLogDeliveryEnabled())
        .map(value => value: Boolean)
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val networkType: Optional[zio.aws.elasticache.model.NetworkType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkType())
        .map(value => zio.aws.elasticache.model.NetworkType.wrap(value))
    override val ipDiscovery: Optional[zio.aws.elasticache.model.IpDiscovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipDiscovery())
        .map(value => zio.aws.elasticache.model.IpDiscovery.wrap(value))
    override val transitEncryptionMode
        : Optional[zio.aws.elasticache.model.TransitEncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionMode())
        .map(value =>
          zio.aws.elasticache.model.TransitEncryptionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheCluster
  ): zio.aws.elasticache.model.CacheCluster.ReadOnly = new Wrapper(impl)
}
