package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait AuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.AuthenticationType
  ): zio.aws.elasticache.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.elasticache.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.AuthenticationType.PASSWORD =>
      val r = password
      r
    case software.amazon.awssdk.services.elasticache.model.AuthenticationType.NO_PASSWORD =>
      val r = `no-password`
      r
    case software.amazon.awssdk.services.elasticache.model.AuthenticationType.IAM =>
      val r = iam
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AuthenticationType =
      software.amazon.awssdk.services.elasticache.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object password extends zio.aws.elasticache.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AuthenticationType =
      software.amazon.awssdk.services.elasticache.model.AuthenticationType.PASSWORD
  }
  case object `no-password`
      extends zio.aws.elasticache.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AuthenticationType =
      software.amazon.awssdk.services.elasticache.model.AuthenticationType.NO_PASSWORD
  }
  case object iam extends zio.aws.elasticache.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.AuthenticationType =
      software.amazon.awssdk.services.elasticache.model.AuthenticationType.IAM
  }
}
