package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{UserGroupId, EngineType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class User(
    userId: Optional[String] = Optional.Absent,
    userName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    engine: Optional[EngineType] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    accessString: Optional[String] = Optional.Absent,
    userGroupIds: Optional[Iterable[UserGroupId]] = Optional.Absent,
    authentication: Optional[zio.aws.elasticache.model.Authentication] =
      Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.User
      .builder()
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        engine.map(value => EngineType.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(authentication.map(value => value.buildAwsValue()))(
        _.authentication
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.User.ReadOnly =
    zio.aws.elasticache.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.elasticache.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.User =
      zio.aws.elasticache.model.User(
        userId.map(value => value),
        userName.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        minimumEngineVersion.map(value => value),
        accessString.map(value => value),
        userGroupIds.map(value => value),
        authentication.map(value => value.asEditable),
        arn.map(value => value)
      )
    def userId: Optional[String]
    def userName: Optional[String]
    def status: Optional[String]
    def engine: Optional[EngineType]
    def minimumEngineVersion: Optional[String]
    def accessString: Optional[String]
    def userGroupIds: Optional[List[UserGroupId]]
    def authentication
        : Optional[zio.aws.elasticache.model.Authentication.ReadOnly]
    def arn: Optional[String]
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, EngineType] =
      AwsError.unwrapOptionField("engine", engine)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getAccessString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.Authentication.ReadOnly
    ] = AwsError.unwrapOptionField("authentication", authentication)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.User
  ) extends zio.aws.elasticache.model.User.ReadOnly {
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val userName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val engine: Optional[EngineType] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.elasticache.model.primitives.EngineType(value))
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val accessString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessString())
      .map(value => value: String)
    override val userGroupIds: Optional[List[UserGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.primitives.UserGroupId(item)
          }.toList
        )
    override val authentication
        : Optional[zio.aws.elasticache.model.Authentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authentication())
        .map(value => zio.aws.elasticache.model.Authentication.wrap(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.User
  ): zio.aws.elasticache.model.User.ReadOnly = new Wrapper(impl)
}
