package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RebalanceSlotsInGlobalReplicationGroupResponse(
    globalReplicationGroup: Optional[
      zio.aws.elasticache.model.GlobalReplicationGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse = {
    import RebalanceSlotsInGlobalReplicationGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
      .builder()
      .optionallyWith(
        globalReplicationGroup.map(value => value.buildAwsValue())
      )(_.globalReplicationGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly =
    zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
      .wrap(buildAwsValue())
}
object RebalanceSlotsInGlobalReplicationGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse =
      zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse(
        globalReplicationGroup.map(value => value.asEditable)
      )
    def globalReplicationGroup
        : Optional[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    def getGlobalReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroup",
      globalReplicationGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
  ) extends zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly {
    override val globalReplicationGroup
        : Optional[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroup())
        .map(value =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
  ): zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly =
    new Wrapper(impl)
}
