package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    retainPrimaryReplicationGroup: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest = {
    import DeleteGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .retainPrimaryReplicationGroup(
        retainPrimaryReplicationGroup: java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object DeleteGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest(
        globalReplicationGroupId,
        retainPrimaryReplicationGroup
      )
    def globalReplicationGroupId: String
    def retainPrimaryReplicationGroup: Boolean
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getRetainPrimaryReplicationGroup: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(retainPrimaryReplicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val retainPrimaryReplicationGroup: Boolean =
      impl.retainPrimaryReplicationGroup(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.DeleteGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
