package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait DataTieringStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.DataTieringStatus
}
object DataTieringStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.DataTieringStatus
  ): zio.aws.elasticache.model.DataTieringStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.DataTieringStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.DataTieringStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.elasticache.model.DataTieringStatus.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.DataTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DataTieringStatus =
      software.amazon.awssdk.services.elasticache.model.DataTieringStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.elasticache.model.DataTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DataTieringStatus =
      software.amazon.awssdk.services.elasticache.model.DataTieringStatus.ENABLED
  }
  case object disabled extends zio.aws.elasticache.model.DataTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.DataTieringStatus =
      software.amazon.awssdk.services.elasticache.model.DataTieringStatus.DISABLED
  }
}
