package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RevokeCacheSecurityGroupIngressResponse(
    cacheSecurityGroup: Optional[zio.aws.elasticache.model.CacheSecurityGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse = {
    import RevokeCacheSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
      .builder()
      .optionallyWith(cacheSecurityGroup.map(value => value.buildAwsValue()))(
        _.cacheSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly =
    zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object RevokeCacheSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse =
      zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse(
        cacheSecurityGroup.map(value => value.asEditable)
      )
    def cacheSecurityGroup
        : Optional[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly]
    def getCacheSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheSecurityGroup", cacheSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
  ) extends zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly {
    override val cacheSecurityGroup
        : Optional[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroup())
        .map(value => zio.aws.elasticache.model.CacheSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
  ): zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
