package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    topicArn: Optional[String] = Optional.Absent,
    topicStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NotificationConfiguration
      .builder()
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(topicStatus.map(value => value: java.lang.String))(
        _.topicStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NotificationConfiguration.ReadOnly =
    zio.aws.elasticache.model.NotificationConfiguration.wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NotificationConfiguration =
      zio.aws.elasticache.model.NotificationConfiguration(
        topicArn.map(value => value),
        topicStatus.map(value => value)
      )
    def topicArn: Optional[String]
    def topicStatus: Optional[String]
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getTopicStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicStatus", topicStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NotificationConfiguration
  ) extends zio.aws.elasticache.model.NotificationConfiguration.ReadOnly {
    override val topicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => value: String)
    override val topicStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.topicStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NotificationConfiguration
  ): zio.aws.elasticache.model.NotificationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
