package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModifyCacheParameterGroupRequest(
    cacheParameterGroupName: String,
    parameterNameValues: Iterable[zio.aws.elasticache.model.ParameterNameValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest = {
    import ModifyCacheParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest
      .builder()
      .cacheParameterGroupName(cacheParameterGroupName: java.lang.String)
      .parameterNameValues(parameterNameValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyCacheParameterGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheParameterGroupRequest
      .wrap(buildAwsValue())
}
object ModifyCacheParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheParameterGroupRequest =
      zio.aws.elasticache.model.ModifyCacheParameterGroupRequest(
        cacheParameterGroupName,
        parameterNameValues.map { item =>
          item.asEditable
        }
      )
    def cacheParameterGroupName: String
    def parameterNameValues
        : List[zio.aws.elasticache.model.ParameterNameValue.ReadOnly]
    def getCacheParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupName)
    def getParameterNameValues: ZIO[Any, Nothing, List[
      zio.aws.elasticache.model.ParameterNameValue.ReadOnly
    ]] = ZIO.succeed(parameterNameValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest
  ) extends zio.aws.elasticache.model.ModifyCacheParameterGroupRequest.ReadOnly {
    override val cacheParameterGroupName: String =
      impl.cacheParameterGroupName(): String
    override val parameterNameValues
        : List[zio.aws.elasticache.model.ParameterNameValue.ReadOnly] = impl
      .parameterNameValues()
      .asScala
      .map { item =>
        zio.aws.elasticache.model.ParameterNameValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest
  ): zio.aws.elasticache.model.ModifyCacheParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
