package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CustomerNodeEndpoint(
    address: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint = {
    import CustomerNodeEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly =
    zio.aws.elasticache.model.CustomerNodeEndpoint.wrap(buildAwsValue())
}
object CustomerNodeEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CustomerNodeEndpoint =
      zio.aws.elasticache.model.CustomerNodeEndpoint(
        address.map(value => value),
        port.map(value => value)
      )
    def address: Optional[String]
    def port: Optional[IntegerOptional]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint
  ) extends zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly {
    override val address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint
  ): zio.aws.elasticache.model.CustomerNodeEndpoint.ReadOnly = new Wrapper(impl)
}
