package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait UpdateActionStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus
}
object UpdateActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.UpdateActionStatus
  ): zio.aws.elasticache.model.UpdateActionStatus = value match {
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.NOT_APPLIED =>
      val r = `not-applied`
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.WAITING_TO_START =>
      val r = `waiting-to-start`
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.IN_PROGRESS =>
      val r = `in-progress`
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.STOPPED =>
      val r = stopped
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.COMPLETE =>
      val r = complete
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.SCHEDULING =>
      val r = scheduling
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.SCHEDULED =>
      val r = scheduled
      r
    case software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.NOT_APPLICABLE =>
      val r = `not-applicable`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `not-applied`
      extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.NOT_APPLIED
  }
  case object `waiting-to-start`
      extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.WAITING_TO_START
  }
  case object `in-progress`
      extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.IN_PROGRESS
  }
  case object stopping extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.STOPPING
  }
  case object stopped extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.STOPPED
  }
  case object complete extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.COMPLETE
  }
  case object scheduling extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.SCHEDULING
  }
  case object scheduled extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.SCHEDULED
  }
  case object `not-applicable`
      extends zio.aws.elasticache.model.UpdateActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.UpdateActionStatus =
      software.amazon.awssdk.services.elasticache.model.UpdateActionStatus.NOT_APPLICABLE
  }
}
