package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CacheParameterGroupStatus(
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    parameterApplyStatus: Optional[String] = Optional.Absent,
    cacheNodeIdsToReboot: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus = {
    import CacheParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus
      .builder()
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        cacheNodeIdsToReboot.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheNodeIdsToReboot)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly =
    zio.aws.elasticache.model.CacheParameterGroupStatus.wrap(buildAwsValue())
}
object CacheParameterGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheParameterGroupStatus =
      zio.aws.elasticache.model.CacheParameterGroupStatus(
        cacheParameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value),
        cacheNodeIdsToReboot.map(value => value)
      )
    def cacheParameterGroupName: Optional[String]
    def parameterApplyStatus: Optional[String]
    def cacheNodeIdsToReboot: Optional[List[String]]
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getCacheNodeIdsToReboot: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheNodeIdsToReboot", cacheNodeIdsToReboot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus
  ) extends zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly {
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val parameterApplyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterApplyStatus())
      .map(value => value: String)
    override val cacheNodeIdsToReboot: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheNodeIdsToReboot())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus
  ): zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly = new Wrapper(
    impl
  )
}
