package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeCacheClustersRequest(
    cacheClusterId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    showCacheNodeInfo: Optional[BooleanOptional] = Optional.Absent,
    showCacheClustersNotInReplicationGroups: Optional[BooleanOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest = {
    import DescribeCacheClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(showCacheNodeInfo.map(value => value: java.lang.Boolean))(
        _.showCacheNodeInfo
      )
      .optionallyWith(
        showCacheClustersNotInReplicationGroups.map(value =>
          value: java.lang.Boolean
        )
      )(_.showCacheClustersNotInReplicationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheClustersRequest.wrap(buildAwsValue())
}
object DescribeCacheClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheClustersRequest =
      zio.aws.elasticache.model.DescribeCacheClustersRequest(
        cacheClusterId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        showCacheNodeInfo.map(value => value),
        showCacheClustersNotInReplicationGroups.map(value => value)
      )
    def cacheClusterId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def showCacheNodeInfo: Optional[BooleanOptional]
    def showCacheClustersNotInReplicationGroups: Optional[BooleanOptional]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getShowCacheNodeInfo: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showCacheNodeInfo", showCacheNodeInfo)
    def getShowCacheClustersNotInReplicationGroups
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "showCacheClustersNotInReplicationGroups",
      showCacheClustersNotInReplicationGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ) extends zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly {
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val showCacheNodeInfo: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.showCacheNodeInfo())
        .map(value => value: BooleanOptional)
    override val showCacheClustersNotInReplicationGroups
        : Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.showCacheClustersNotInReplicationGroups())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ): zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly =
    new Wrapper(impl)
}
